package jp.ac.titech.sharp4k.cuten.sampletask.polychoron;

public class ScreenInfo {
	public float w;// 解像度
	public float h;// 解像度
	public float centerX;// ワールド空間上の画面の中心に当たる点
	public float centerY;// ワールド空間上の画面の中心に当たる点
	public float scale;// 表示が何倍か（1/scale=画面端の座標）

	public ScreenInfo() {
		centerX = 0;
		centerY = 0;
		scale = 0.5f;
	}

	public float worldToScreenX(float x) {
		return ((x - centerX) * scale) * (w / 2);
	}

	public float worldToScreenY(float y) {
		return ((y - centerY) * scale) * (h / 2);
	}

	public float screenToWorldX(float sx) {
		return sx / (w / 2) / scale + centerX;
	}

	public float screenToWorldY(float sy) {
		return sy / (h / 2) / scale + centerY;
	}

	public float screenToWorldXDiff(float sx) {
		return sx / (w / 2) / scale;
	}

	public float screenToWorldYDiff(float sy) {
		return sy / (h / 2) / scale;
	}
}
