class Lecture < ActiveRecord::Base
  belongs_to :teacher
  has_many :tasks
  attr_accessible :name

  validates_presence_of :name

  include JsonWithoutTimestamps
  def as_json(options = {})
    super options.merge({:methods => [:teacher], :except => [:teacher_id]}) { |k, v1, v2| v1 + v2 }
  end
end
