package jp.ac.titech.sharp4k.cuten.app;

import jp.ac.titech.sharp4k.cuten.BaseApp;
import jp.ac.titech.sharp4k.cuten.R;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Color;
import android.view.Gravity;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

public class CircuitTask extends BaseApp implements OnClickListener {
	private int questionSize;

	static final int FP = ViewGroup.LayoutParams.FILL_PARENT;
	static final int WC = ViewGroup.LayoutParams.WRAP_CONTENT;

	static final int AND = 0;
	static final int OR = 1;
	static final int NOT = 2;
	static final int COLOR_WHEN_SELECTED = Color.RED;
	private int defaultBtnColor;

	static final float QUESTION_TEXT_SIZE = 30.0f;
	static final float ANSWER_TEXT_SIZE = 25.0f;

	private static final String TAG = CircuitTask.class.getSimpleName();
	private Context cxt;
	private Resources res;
	private Button submitBtn;
	private int[] correctAnswer;
	private int[] userAnswer;
	private ImageView[] answerView;

	private ImageButton andBtn;
	private ImageButton orBtn;
	private ImageButton notBtn;

	LinearLayout viewLayout;
	LinearLayout questionLayout;
	LinearLayout answerLayout;

	private Button solvingQuestionButton;

	@Override
	protected View createView(final Context cxt, Resources res) {
		// TODO 自動生成されたメソッド・スタブ
		this.cxt = cxt;
		this.res = res;
		
		correctAnswer = res.getIntArray(R.array.answer_array);
		questionSize = correctAnswer.length;
		userAnswer = new int[questionSize];
		answerView = new ImageView[questionSize];
		
		for (int i = 0; i < questionSize; i++) {
			userAnswer[i] = -1;
		}
		


		viewLayout = new LinearLayout(cxt);
		viewLayout.setLayoutParams(new LayoutParams(WC, WC));

		if (res.getConfiguration().orientation == Configuration.ORIENTATION_PORTRAIT) {
			viewLayout.setOrientation(LinearLayout.VERTICAL);
		} else if (res.getConfiguration().orientation == Configuration.ORIENTATION_LANDSCAPE) {
			viewLayout.setOrientation(LinearLayout.HORIZONTAL);
		}

		questionLayout = new LinearLayout(cxt);
		questionLayout.setLayoutParams(new LayoutParams(WC, WC));
		questionLayout.setHorizontalGravity(Gravity.CENTER);
		questionLayout.setOrientation(LinearLayout.VERTICAL);

		TextView textView = new TextView(cxt);
		textView.setText(res.getText(R.string.question));
		textView.setLayoutParams(new LayoutParams(WC, WC));
		textView.setTextSize(QUESTION_TEXT_SIZE);

		ImageView imageView = new ImageView(cxt);
		imageView.setLayoutParams(new LayoutParams(WC, WC));
		imageView.setImageDrawable(res.getDrawable(R.drawable.question));

		LinearLayout selectBtnLayout = new LinearLayout(cxt);
		selectBtnLayout.setOrientation(LinearLayout.HORIZONTAL);
		selectBtnLayout.setLayoutParams(new LayoutParams(WC, FP));
		createBtnArray(selectBtnLayout);

		submitBtn = new Button(cxt);
		submitBtn.setText("Submit");
		submitBtn.setLayoutParams(new LayoutParams(WC, WC));
		submitBtn.setOnClickListener(this);
		
		ColorStateList mList = submitBtn.getTextColors();
		defaultBtnColor = mList.getDefaultColor();

		questionLayout.addView(textView);
		questionLayout.addView(imageView);
		questionLayout.addView(selectBtnLayout);
		questionLayout.addView(submitBtn);

		answerLayout = createAnswerLayout(cxt);
		answerLayout.setLayoutParams(new LayoutParams(WC, WC));
		answerLayout.setOrientation(LinearLayout.VERTICAL);

		viewLayout.addView(questionLayout);
		viewLayout.addView(answerLayout);

		return viewLayout;
	}

	private void createBtnArray(LinearLayout selectBtnLayout) {
		andBtn = new ImageButton(cxt);
		andBtn.setOnClickListener(this);
		andBtn.setImageDrawable(res.getDrawable(R.drawable.and));

		orBtn = new ImageButton(cxt);
		orBtn.setOnClickListener(this);
		orBtn.setImageDrawable(res.getDrawable(R.drawable.or));

		notBtn = new ImageButton(cxt);
		notBtn.setOnClickListener(this);
		notBtn.setImageDrawable(res.getDrawable(R.drawable.not));

		selectBtnLayout.addView(andBtn);
		selectBtnLayout.addView(orBtn);
		selectBtnLayout.addView(notBtn);
	}

	private LinearLayout createAnswerLayout(Context cxt) {
		LinearLayout layout = new LinearLayout(cxt);
		layout.setOrientation(LinearLayout.HORIZONTAL);

		for (int i = 0; i < questionSize; i++) {
			LinearLayout line = new LinearLayout(cxt);
			line.setVerticalGravity(Gravity.CENTER);
			Button questionBtn = new Button(cxt);
			questionBtn.setText("Q" + (i + 1) + " : ");
			questionBtn.setTextSize(ANSWER_TEXT_SIZE);
			questionBtn.setOnClickListener(this);
			questionBtn.setId(i);
			answerView[i] = new ImageView(cxt);

			line.addView(questionBtn);
			line.addView(answerView[i]);
			layout.addView(line);
		}

		return layout;
	}

	@Override
	protected void onClose() {

		super.onClose();
	}

	@Override
	public void onClick(View v) {
		// TODO 自動生成されたメソッド・スタブ
		if (v.equals(submitBtn)) {
			int[] result = new int[questionSize];
			for (int i = 0; i < result.length; i++) {
				if (correctAnswer[i] == userAnswer[i]) {
					result[i] = 10;
				} else {
					result[i] = 0;
				}
			}
			sendResult(result);
			close();

		} else if (solvingQuestionButton != null) {
			if (v.equals(andBtn)) {
				userAnswer[solvingQuestionButton.getId()] = AND;
				answerView[solvingQuestionButton.getId()].setImageDrawable(res
						.getDrawable(R.drawable.and));
				solvingQuestionButton.setTextColor(defaultBtnColor);
				solvingQuestionButton = null;

			} else if (v.equals(orBtn)) {
				userAnswer[solvingQuestionButton.getId()] = OR;
				answerView[solvingQuestionButton.getId()].setImageDrawable(res
						.getDrawable(R.drawable.or));
				solvingQuestionButton.setTextColor(defaultBtnColor);
				solvingQuestionButton = null;

			} else if (v.equals(notBtn)) {
				userAnswer[solvingQuestionButton.getId()] = NOT;
				answerView[solvingQuestionButton.getId()].setImageDrawable(res
						.getDrawable(R.drawable.not));
				solvingQuestionButton.setTextColor(defaultBtnColor);
				solvingQuestionButton = null;

			} else {
				solvingQuestionButton.setTextColor(defaultBtnColor);
				setSolvingQustion(v);
			}
		} else {
			if (v.equals(andBtn) || v.equals(orBtn) || v.equals(notBtn))
				Toast.makeText(cxt, "問題を選びましょう(Q1の部分をタップ)", Toast.LENGTH_LONG)
						.show();
			else {
				setSolvingQustion(v);
			}
		}
	}

	private void setSolvingQustion(View v) {
		if (v.getClass().equals(Button.class)) {
			solvingQuestionButton = (Button) v;
			solvingQuestionButton.setTextColor(COLOR_WHEN_SELECTED);
		}
	}

	protected void onConfigurationChanged(Configuration newConfig) {
		if (newConfig.orientation == Configuration.ORIENTATION_PORTRAIT) {
			viewLayout.setOrientation(LinearLayout.VERTICAL);
		} else if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE) {
			viewLayout.setOrientation(LinearLayout.HORIZONTAL);
		}
	}
}
