package jp.ac.titech.sharp4k.cuten.sampletask;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.FontMetrics;
import android.graphics.Paint.Style;
import android.view.MotionEvent;
import android.view.View;

public class MatrixView extends View {
	private Resources res;
	private float width, height;
	private int row, col;
	private int[] opcol;
	private String[][] bits, cAnswer;
	private TypedArray question;

	public MatrixView(Context ctx, Resources res, int questionId) {
		super(ctx);
		setFocusable(true);
		setFocusableInTouchMode(true);
		this.res = res;
		question = res.obtainTypedArray(questionId);
		row = question.getInteger(0, -1);
		col = question.getInteger(1, -1);
		opcol = res.getIntArray(question.getResourceId(2, -1));
		TypedArray code = res.obtainTypedArray(question.getResourceId(3, -1));
		bits = new String[code.length()][];
		for (int i = 0; i < code.length(); i++) {
			bits[i] = res.getStringArray(code.getResourceId(i, -1));
		}
		cAnswer = new String[opcol.length - 1][];
		TypedArray answer = res.obtainTypedArray(question.getResourceId(4, -1));
		for (int i = 0; i < answer.length(); i++) {
			cAnswer[i] = res.getStringArray(answer.getResourceId(i, -1));
		}
	}

	@Override
	protected void onSizeChanged(int w, int h, int oldw, int oldh) {
		width = w / (col + 2);
		height = h / (row + 2);
		super.onSizeChanged(w, h, oldw, oldh);
	}

	@Override
	protected void onDraw(Canvas canvas) {
		// draw operable Rects
		Paint opRect = new Paint();
		opRect.setARGB(50, 0, 255, 255);
		for (int i = 0; i < opcol.length; i++) {
			if (i == opcol.length - 1) {
				canvas.drawRect(width * opcol[i], height, width
						* (opcol[i] + 1), height * (row + 1), opRect);
			} else {
				canvas.drawRect(width * opcol[i], height, width
						* (opcol[i] + 1), height * row, opRect);
			}
		}

		// draw matrix line
		Paint line = new Paint();
		line.setColor(Color.GRAY);
		for (int i = 1; i < row + 2; i++) {
			canvas.drawLine(width, i * height, width * (col + 1), i * height,
					line);
		}
		for (int i = 1; i < col + 2; i++) {
			canvas.drawLine(i * width, height, i * width, height * (row + 1),
					line);
		}

		// draw cross in unused box
		canvas.drawLine(width * (col - 1), height * row, width * col, height
				* (row + 1), line);
		canvas.drawLine(width * col, height * row, width * (col - 1), height
				* (row + 1), line);

		// draw boundary between code and extra row
		Paint boundary = new Paint();
		boundary.setColor(Color.BLUE);
		canvas.drawLine(width, height * row, width * (col + 1), height * row,
				boundary);

		// draw checksum line
		Paint cline = new Paint();
		cline.setColor(Color.RED);
		canvas.drawLine(width * (col - 1), height, width * (col - 1), height
				* row - 2, cline);
		canvas.drawLine(width * col, height, width * col, height * row - 2,
				cline);
		canvas.drawLine(width * (col - 1), height, width * col, height, cline);
		canvas.drawLine(width * (col - 1), height * row - 2, width * col,
				height * row - 2, cline);
		canvas.drawLine(width * col, height, width * col, height * (row + 1),
				cline);
		canvas.drawLine(width * (col + 1), height, width * (col + 1), height
				* (row + 1), cline);
		canvas.drawLine(width * col, height, width * (col + 1), height, cline);
		canvas.drawLine(width * col, height * (row + 1), width * (col + 1),
				height * (row + 1), cline);

		// bits
		Paint foreground = new Paint(Paint.ANTI_ALIAS_FLAG);
		foreground.setColor(Color.GRAY);
		foreground.setStyle(Style.FILL);
		foreground.setTextSize(height * 0.75f);
		foreground.setTextScaleX(width / height);
		foreground.setTextAlign(Paint.Align.CENTER);
		FontMetrics fm = foreground.getFontMetrics();
		float x = width / 2;
		float y = height / 2 - (fm.ascent + fm.descent) / 2;
		for (int i = 1; i < row + 1; i++) {
			for (int j = 1; j < col + 1; j++) {
				canvas.drawText(bits[i - 1][j - 1], j * width + x, i * height
						+ y, foreground);
			}
		}
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		if (event.getAction() != MotionEvent.ACTION_DOWN) {
			return super.onTouchEvent(event);
		} else {
			// position
			int selX, selY;
			selX = (int) (event.getX() / width);
			selY = (int) (event.getY() / height);
			if (selX <= 0 || selY <= 0 || selX > col || selY > row
					|| selX < col && selY == row) {
				return true;
			}
			int check;
			for (check = 0; check < opcol.length; check++) {
				if (selX == opcol[check]) {
					break;
				}
			}
			if (check == opcol.length) {
				return true;
			}
			if (bits[selY - 1][selX - 1].equals("0")) {
				bits[selY - 1][selX - 1] = "1";
			} else {
				bits[selY - 1][selX - 1] = "0";
			}
			invalidate();
		}
		return true;
	}

	public void reset() {
		TypedArray code = res.obtainTypedArray(question.getResourceId(3, -1));
		bits = new String[code.length()][];
		for (int i = 0; i < code.length(); i++) {
			bits[i] = res.getStringArray(code.getResourceId(i, -1));
		}
		invalidate();
	}

	public int mark() {
		for (int i = 0; i < opcol.length - 1; i++) {
			for (int j = 0; j < row - 1; j++) {
				if (!bits[j][opcol[i] - 1].equals(cAnswer[i][j])) {
					return 0;
				}
			}
		}
		return 100;
	}
}