require 'test_helper'

class ApksControllerTest < ActionController::TestCase
  setup do
    @apk = FactoryGirl.create :apk
  end

  test "should NOT get index" do
    assert_no_routes do
      get :index
    end
  end

  test "should NOT get new" do
    assert_no_routes do
      get :new
    end
  end

  test "should NOT create apk" do
    assert_no_routes do
      post :create, apk: { name: @apk.name }
    end
  end

  test "should show apk" do
    get :show, id: @apk
    assert_response :success
  end

  test "should NOT update apk" do
    assert_no_routes do
      put :update, id: @apk, apk: { name: @apk.name }
    end
  end

  test "should destroy apk" do
    assert_no_routes do
      delete :destroy, id: @apk
    end
  end

  test "should download uploaded file" do
    get :download, :id => @apk
    fixture = File.read @apk.apk.path, :encoding => 'binary'
    assert_equal fixture, @response.body
  end
end
