package jp.ac.titech.sharp4k.cuten.test;

import java.util.ArrayList;
import java.util.List;

import jp.ac.titech.sharp4k.cuten.Achievement;
import jp.ac.titech.sharp4k.cuten.Apk;
import jp.ac.titech.sharp4k.cuten.HttpAPIClient;
import jp.ac.titech.sharp4k.cuten.HttpResponseListener;
import jp.ac.titech.sharp4k.cuten.Lecture;
import jp.ac.titech.sharp4k.cuten.LectureActivity;
import jp.ac.titech.sharp4k.cuten.LectureFolderActivity;
import jp.ac.titech.sharp4k.cuten.SQLHelper;
import jp.ac.titech.sharp4k.cuten.Task;
import jp.ac.titech.sharp4k.cuten.Teacher;
import android.content.Context;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.view.ViewGroup;
import android.widget.TextView;

import com.google.inject.AbstractModule;

public class LectureActivityTest extends
		ActivityTestCaseWithRobo<LectureActivity> {
	private static class NormalHttpModule extends AbstractModule {
		@Override
		protected void configure() {
			bind(HttpAPIClient.class).to(NormalHttpAPIClient.class);
		}
	}

	private static class NormalHttpAPIClient extends NullHttpAPIClient {
		@Override
		public void putAchievement(String token, Achievement achievement,
				HttpResponseListener listener) {
			listener.preExec();
			listener.onSuccess("");
			listener.postExec();
		}
	}

	private LectureActivity activity;
	private TextView lectureInfo;
	private TextView teacherInfo;
	private Lecture dummyLecture;
	private List<Task> dummyTasks;

	public LectureActivityTest() {
		super(LectureActivity.class, new NormalHttpModule());
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		Context ctx = getInstrumentation().getTargetContext();
		setupDB(ctx);
		Intent intent = new Intent(Intent.ACTION_MAIN);
		intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
		intent.putExtra(LectureFolderActivity.LECTURE_KEY, dummyLecture.getId());
		setActivityIntent(intent);

		activity = getActivity();
		lectureInfo = (TextView) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.lecture_info_name);
		teacherInfo = (TextView) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.lecture_info_teacher);
	}

	private void setupDB(Context ctx) {
		Teacher t = new Teacher(1001, "tea1", null);
		dummyLecture = new Lecture(1001, "lec1", t);
		dummyTasks = new ArrayList<Task>();
		for (int i = 1; i <= 3; i++) {
			dummyTasks.add(new Task(1000 + i, "task" + i, dummyLecture));
		}

		SQLiteOpenHelper h = new SQLHelper(ctx);
		SQLiteDatabase db = h.getWritableDatabase();
		t.save(db, ctx);
		dummyLecture.save(db);
		for (Task task : dummyTasks) {
			task.save(db);
			Apk apk = new Apk(task.getId(), 1, "com.example.dummy.Task"
					+ task.getId(), task);
			apk.save(db);
		}
		db.close();
	}

	public void testLectureInfoContainsLectureName() throws Exception {
		assertNotNull(lectureInfo);
		String text = lectureInfo.getText().toString();
		assertTrue(text.contains(dummyLecture.getName()));
	}

	public void testTeacherInfoContainsTeacherName() throws Exception {
		assertNotNull(teacherInfo);
		String text = teacherInfo.getText().toString();
		assertTrue(text.contains(dummyLecture.getTeacher().getName()));
	}

	public void testListingTasks() throws Exception {
		ViewGroup vg = (ViewGroup) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.linearViewLecture);
		assertNotNull(vg);
		assertEquals(dummyTasks.size(), vg.getChildCount());
	}

	public void testListingTaskNames() throws Exception {
		ViewGroup vg = (ViewGroup) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.linearViewLecture);
		assertNotNull(vg);
		for (int i = 0; i < dummyTasks.size(); i++) {
			Task task = dummyTasks.get(i);
			TextView v = (TextView) vg.getChildAt(i);
			assertTrue(v.getText().toString().contains(task.getName()));
		}
	}
}