/**
 * Copyright (C) 2008-2011 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.util.ArrayList;

import jp.robotbrain.signal.IndexObjectList;

/**
 * ׂẴeNjJwWXg[̃X[p[NX
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2012 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public abstract class IndexStream extends TradeComponent {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * eNjJwW󂯎|[g̃Xg
	 * 
	 * @since 2.60
	 */
	private final IndexStreamPortList m_portList;
	
	/**
	 * eNjJwWʒm惊Xg
	 * 
	 * @since 1.00
	 */
	private final ArrayList<IndexStream> m_destinationList;
	
	/**
	 * ŌɒʒmꂽeNjJwW̃^O
	 * 
	 * @since 2.40
	 */
	private Tag m_prevTag;

	/**
	 * eNjJwWʒm̒ōő̃RXgiKvƂ̓eNjJwW̐j
	 * 
	 * @since 2.40
	 */
	private int m_destinationMaxCost;

	/**
	 * IndexStream𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_label x
	 */
	public IndexStream(String p_label) {
		super(p_label);
		m_portList = new IndexStreamPortList();
		m_destinationList = new ArrayList<IndexStream>();
	}

	/**
	 * eNjJwW̒ʒm܂B
	 * 
	 * @since 2.60
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	public final void notifyIndex() throws IndexStreamException {
		// ͒l̃`FbN
		for (IndexStreamPort port: getPortList().values()) {
			// null`FbN
			if (port.getIndexStream()==null) {
				throw new IndexStreamException("Null Error");
			}
			IndexObjectList<?> idxList = port.getIndexStream().getValues();
			if (idxList==null) {
				throw new IndexStreamException("Null Error");
			}
			// TCY`FbN
			if (idxList.size()<port.getCost()) {
				return;
			}
		}
		// qNXpĂяo
		notifyIndexSub();
	}

	/**
	 * qNXɃeNjJwW̒ʒm܂B
	 * 
	 * @since 2.60
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	protected abstract void notifyIndexSub() throws IndexStreamException;
	
	/**
	 * O`FbÑ^OƓꍇtrueԂ܂B
	 * 
	 * @since 2.40
	 * @param p_tag `FbNΏۂ̃eNjJwWXg
	 * @return O`FbÑ^OƓꍇtrue
	 */
	protected boolean isTagChanged() {
		if (getValues().size()<=0) return false;
		Tag tag = getValues().getLast().getTag();
		boolean returnValue = !tag.equals(m_prevTag);
		return returnValue;
	}
	
	/**
	 * ʒmɃeNjJwWn܂B
	 * 
	 * @since 1.00
	 * @throws IndexStreamException eNjJwWZoʒmɈُ킪ꍇ
	 */
	protected final void notifyIndexNext() throws IndexStreamException {
		// V^O̎wWǉĂ邩mF
		if (!isTagChanged()) return;
		m_prevTag = getValues().getLast().getTag();
		// ̎wWɕύXʒB
		for (IndexStream i: m_destinationList) {
			if (i!=null) {
				i.notifyIndex();
			}
		}
	}

	/**
	 * eNjJwW̃XgԂ܂B
	 * 
	 * @since 1.00
	 * @return eNjJwW̃Xg
	 */
	public abstract IndexObjectList<?> getValues(); 
	
	/**
	 * ʒmǉ܂B
	 * 
	 * @since 2.60
	 * @param p_indexStream ʒmeNjJwWBʒm悪VOin̏ꍇnulln܂B
	 * @param p_indexStreamPort ʒmeNjJwW̓̓|[gB|[g̓̓eNjJwWւ̎QƂXV邽߂ɓn܂B
	 */
	public final void addDestination(IndexStream p_indexStream, IndexStreamPort p_indexStreamPort) {
		p_indexStreamPort.setIndexStream(this);
		if (p_indexStream!=null) m_destinationList.add(p_indexStream);
		if (p_indexStreamPort.getCost()>m_destinationMaxCost) {
			m_destinationMaxCost = p_indexStreamPort.getCost();
		}
	}
	
	/**
	 * eNjJwWʒm̒ōő̃RXgiKvƂeNjJwW̐jݒ肵܂B
	 * 
	 * @since 2.40
	 * @param p_destinationMaxCost eNjJwWʒm̒ōő̃RXgiKvƂeNjJwW̐j
	 */
	protected void setDestinationMaxCost(int p_destinationMaxCost) {
		m_destinationMaxCost = p_destinationMaxCost;
	}

	/**
	 * eNjJwWʒm̒ōő̃RXgiKvƂeNjJwW̐jԂ܂B
	 * 
	 * @since 2.40
	 * @return eNjJwWʒm̒ōő̃RXgiKvƂeNjJwW̐j
	 */
	public int getDestinationMaxCost() {
		return m_destinationMaxCost;
	}
	
	/**
	 * eNjJwW󂯎|[g̃XgԂ܂B
	 * 
	 * @since 2.60
	 * @return eNjJwW󂯎|[g̃Xg
	 */
	public IndexStreamPortList getPortList() {
		return m_portList;
	}

	/**
	 * eNjJwW̕ێʂ\Ȍ菬ăʂ}B
	 * 
	 * @since 2.40
	 */
	public abstract void economizeCapacity();

	/**
	 * Xg[Ɋ܂܂邷ׂẴeNjJwWXML\Ԃ܂B
	 * 
	 * @since 2.02
	 * @return Xg[Ɋ܂܂邷ׂẴeNjJwWXML\
	 */
	public final String toXml() {
		if (getValues().size()<=0) return "";
		StringBuilder returnValue = new StringBuilder();
		returnValue.append("<component label=\"");
		returnValue.append(getLabel());
		returnValue.append("\">");
		returnValue.append(getValues().toXml());
		returnValue.append("</component>");
		return returnValue.toString();
	}
	
}
