/**
 * Copyright (C) 2008-2009 RobotBrain. All Rights Reserved.
 * ̃vO̓t[\tgEFAłBȂ͂t[\tgEFAc
 * ɂĔsꂽGNU򓙈ʌOpo[W3(LGPLv3)߂
 * ōĔЕz܂͉ς邱Ƃł܂B
 * ̃vO͗Lpł邱ƂĔЕz܂S̖ۏ؂łB
 * Ɖ\̕ۏ؂ړIւ̓ḰAOɎꂽ̂܂ߑS݂
 * BڂGNU򓙈ʌOpo[W3(LGPLv3)B
 * Ȃ͂̃vOƋɁAGNU򓙈ʌOpo[W3(LGPLv3)
 * Rs[ꕔ󂯎Ă͂łB
 * 󂯎ĂȂ<http://www.gnu.org/licenses/>B
 */
package jp.robotbrain.signal;

import java.awt.Color;
import java.io.PrintStream;
import java.io.Serializable;

import jp.robotbrain.framework.Current;

/**
 * [\N
 * 
 * @since 1.00
 * @author Copyright (C) 2008-2009 <a href="http://robotbrain.jp">
 * RobotBrain.</a> All Rights Reserved.
 */
public class CandleStick extends IndexPoint implements Current,Cloneable,Serializable {

	/**
	 * VAo[WID
	 *  
	 * @since 1.00
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * nl
	 * 
	 * @since 1.00
	 */
	private double m_open;

	/**
	 * l
	 * 
	 * @since 1.00
	 */
	private double m_high;
	
	/**
	 * l
	 * 
	 * @since 1.00
	 */
	private double m_low;

	/**
	 * Il
	 * 
	 * @since 1.00
	 */
	private double m_close;

	/**
	 * z̓hԂF
	 * 
	 * @since 2.60
	 */
	private Color m_plusColor;

	/**
	 * A̓hԂF
	 * 
	 * @since 2.60
	 */
	private Color m_minusColor;
	
	/**
	 * CandleStick𐶐܂B
	 * 
	 * @since 2.34
	 */
	public CandleStick() {
		super();
		m_plusColor = Color.WHITE;
		m_minusColor = Color.BLACK;
	}
	
	/**
	 * CandleStick𐶐܂B
	 * 
	 * @since 1.00
	 * @param p_tag ^O
	 * @param p_open nl
	 * @param p_high l
	 * @param p_low l
	 * @param p_close Il
	 */
	public CandleStick(Tag p_tag, double p_open, double p_high, double p_low, double p_close) {
		super(p_tag, p_close);
		m_open = p_open;
		m_high = p_high;
		m_low = p_low;
		m_close = p_close;
		m_plusColor = Color.WHITE;
		m_minusColor = Color.BLACK;
	}
	
	/**
	 * ̃IuWFNg̃Rs[쐬ĕԂ܂B
	 * 
	 * @since 2.01
	 * @return ̃IuWFNg̃Rs[ 
	 */
	@Override
	public CandleStick clone() {
		CandleStick returnValue = new CandleStick(this.getTag(), 
				this.m_open, this.m_high, this.m_low, this.m_close);
		returnValue.setPlusColor(this.m_plusColor);
		returnValue.setMinusColor(this.m_minusColor);
		return returnValue;
	}
	
	/**
	 * nlԂ܂B
	 * 
	 * @since 1.00
	 * @return nl
	 */
	public double getOpen() {
		return m_open;
	}

	/**
	 * nlݒ肵܂B
	 * 
	 * @since 2.32
	 * @param p_open nl
	 */
	public void setOpen(double p_open) {
		m_open = p_open;
	}

	/**
	 * lԂ܂B
	 * 
	 * @since 1.00
	 * @return l
	 */
	public double getHigh() {
		return m_high;
	}

	/**
	 * lݒ肵܂B
	 * 
	 * @since 2.32
	 * @param p_high l
	 */
	public void setHigh(double p_high) {
		m_high = p_high;
	}

	/**
	 * lԂ܂B
	 * 
	 * @since 1.00
	 * @return l
	 */
	public double getLow() {
		return m_low;
	}

	/**
	 * lݒ肵܂B
	 * 
	 * @since 2.32
	 * @param p_low l
	 */
	public void setLow(double p_low) {
		m_low = p_low;
	}

	/**
	 * IlԂ܂B
	 * 
	 * @since 1.00
	 * @return Il
	 */
	public double getClose() {
		return m_close;
	}

	/**
	 * Ilݒ肵܂B
	 * 
	 * @since 2.32
	 * @param p_close Il
	 */
	public void setClose(double p_close) {
		m_close = p_close;
		setValue(m_close);
	}
	
	@Override
	public boolean isSet() {
		return true;
	}

	/**
	 * lAlAIl̕ϒlԂ܂B
	 * 
	 * @since 1.00
	 * @return lAlAIl̕ϒl
	 */
	public double getAvg() {
		return (getHigh() + getLow() + getClose()) / 3;
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#printHeader(java.io.PrintStream)
	 */
	@Override
	public void printHeader(PrintStream p_out) {
		p_out.println("Tag,Open,High,Low,Close,Avg");
	}
	
	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#print(java.io.PrintStream)
	 */
	@Override
	public void print(PrintStream p_out) {
		p_out.println("'" + getTag().getValue() + "'," + getOpen() + "," + 
				getHigh() + "," + getLow() + "," + getClose() + "," + getAvg());
	}

	/* ( Javadoc)
	 * @see jp.robotbrain.signal.IndexObject#toXml()
	 */
	@Override
	public final String toXml() {
		StringBuilder returnValue = new StringBuilder();
		returnValue.append("<candlestick tag=\"");
		returnValue.append(getTag().getValue());
		returnValue.append("\">");
		returnValue.append("<open>");
		returnValue.append(getOpen());
		returnValue.append("</open>");
		returnValue.append("<high>");
		returnValue.append(getHigh());
		returnValue.append("</high>");
		returnValue.append("<low>");
		returnValue.append(getLow());
		returnValue.append("</low>");
		returnValue.append("<close>");
		returnValue.append(getClose());
		returnValue.append("</close>");
		returnValue.append("<avg>");
		returnValue.append(getAvg());
		returnValue.append("</avg>");
		returnValue.append("</candlestick>");
		return returnValue.toString();
	}

	/**
	 * z̓hԂFԂ܂B
	 * 
	 * @since 2.60
	 * @return z̓hԂF
	 */
	public Color getPlusColor() {
		return m_plusColor;
	}

	/**
	 * z̓hԂFݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_plusColor z̓hԂF
	 */
	public void setPlusColor(Color p_plusColor) {
		m_plusColor = p_plusColor;
	}

	/**
	 * A̓hԂFԂ܂B
	 * 
	 * @since 2.60
	 * @return A̓hԂF
	 */
	public Color getMinusColor() {
		return m_minusColor;
	}

	/**
	 * A̓hԂFݒ肵܂B
	 * 
	 * @since 2.60
	 * @param p_minusColor A̓hԂF
	 */
	public void setMinusColor(Color p_minusColor) {
		m_minusColor = p_minusColor;
	}
	
}
