<?php
// pcntl_signalのコールバック関数を処理するために、
// ticksの設定が必要。
declare(ticks = 1);
// シグナルキューの長さ
define('MAX_SIG_QUEUE_LEN', 3);
// メイン処理のインターバル
define('SLEEP_SECS', 1);
// シグナルを保持するキュー
$sigQueue = array();

/**
 * シグナルをキューに格納する。
 * @param $signo
 * @return unknown_type
 */
function sigEnqueue($signo = NULL)
{
    global $sigQueue;
	$sigQueue[] = $signo;
}

/**
 * シグナルをキューから読み出す。
 * @return unknown_type
 */
function sigDequeue()
{
    global $sigQueue;
    return array_shift($sigQueue);
}

/**
 * シグナル受信時に、それをキューに格納する。
 * @param $signo
 * @return unknown_type
 */
function sigHandler($signo = NULL)
{
    global $sigQueue;
	// シグナルを保存する。 
    // キューがあふれたら、無視
	if ( count($sigQueue) >= MAX_SIG_QUEUE_LEN ) {
    	return NULL;
    }
    sigEnqueue($signo);    
    return;
}

/**
 * シグナル処理を行う。
 * @param $signo　シグナル
 * @return unknown_type
 */
function sigCheck($signo)
{
	$ret = true;
    switch ($signo)
    {
	    case SIGTERM:   // 終了シグナル
	        $ret = FALSE; // 終了
	        print "SIGTERM\n";
	        break;
	    case SIGHUP:    // HUPシグナル
	        // デーモン再起動処理
	        print "SIGHUP\n";
	        break;
	    case SIGCHLD:   // 子プロセスが終了した場合
	        // 子プロセスのリソースの回収
	        pcntl_waitpid(-1, $status, WNOHANG);
	        print "SIGCHLD\n";
	        break;
	    default:
            print "NULL\n";
    }
    return $ret;
}

/**
 * 自分自身をデーモン化する。
 * @return unknown_type
 */
function daemonize(){
	// 固定処理 ---> ここから
    if (($pid = pcntl_fork()) != 0 ) {
    	print "create1 : pid=$pid \n";
        exit;
    }
    posix_setsid();
    if (($pid = pcntl_fork()) != 0 ) {
        print "create2 : pid=$pid \n";
    	exit;
    }
    chdir("/");
    umask(0);
    // 固定処理 <--- ここまで
    
    pcntl_signal(SIGTERM, "sigHandler");
//    pcntl_signal(SIGCHLD, "sigHandler");
    
    return getmypid();
}

/**
 * デーモン初期化処理
 * @return unknown_type
 */
function init()
{
	// DB接続処理
	// logger準備
}

/**
 * デーモンのメイン処理
 * @return unknown_type
 */
function main() 
{
	// メール配信情報をチェックし、未処理のものがあれば
	// 子プロセスに配信を依頼する。
}


$pid = getmypid();
print "parent process : $pid \n";
$pid = daemonize();
print "child process : $pid \n";


try {
    init();
	// デーモンのメイン処理
	$cnt = 0;
	$alive = true;
	while($alive)
	{
		// メイン処理を行う。
		main();
		//　処理が一区切りついたら、シグナルを処理する。
		$alive = sigCheck(sigDequeue());
		if ($alive) {
		    // 処理の合間にスリープする。
		    sleep(SLEEP_SECS);
		}
		if ($cnt++ > 10) {
			$alive = false; 
		}
    }
} catch (Exception $e) {
    print "Error! \n";
}
?>
