/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.systems;

import static jp.sf.orangesignal.ta.TechnicalAnalysis.mom;
import jp.sf.orangesignal.ta.FourPrice;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

/**
 * モメンタムを使用するストラテジーの基底クラスを提供します。
 */
public abstract class Momentum extends TradingStrategySupport {

	/**
	 * 4本値の種類を保持します。
	 */
	private FourPrice price = FourPrice.CLOSE;

	/**
	 * 4本値の種類を返します。
	 * 
	 * @return 4本値の種類
	 */
	public FourPrice getPrice() { return price; }

	/**
	 * 4本値の種類を設定します。
	 * 
	 * @param price 4本値の種類
	 */
	public void setPrice(final FourPrice price) { this.price = price; }

	/**
	 * モメンタムの期間を保持します。
	 */
	private int period = 12;

	/**
	 * モメンタムの期間を返します。
	 * 
	 * @return モメンタムの期間
	 */
	public int getPeriod() { return period; }

	/**
	 * モメンタムの期間を設定します。
	 * 
	 * @param period モメンタムの期間
	 */
	public void setPeriod(final int period) { this.period = period; }

	// ----------------------------------------------------------------------

	protected Number[] mom1;
	protected Number[] mom2;

	@Override
	public void prepare() {
		final Number[] price = getDataset().getTechnicalPrice(this.price);
		this.mom1 = mom(price, period);
		this.mom2 = mom(this.mom1, 1);
	}

	@Override
	public void close() {
		this.mom1 = null;
		this.mom2 = null;
	}

}
