/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.filters;

import jp.sf.orangesignal.ta.candle.Candlestick;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

/**
 * 指定された直近期間内の取組有無でフィルターするストラテジーを提供します。
 * 
 * @author 杉澤 浩二
 */
public class NoPriceFilter extends TradingStrategySupport {

	/**
	 * デフォルトコンストラクタです。
	 */
	public NoPriceFilter() {}

	/**
	 * 直近期間を保持します。
	 */
	private int period = 5;

	/**
	 * 直近期間を返します。
	 * 
	 * @return 直近期間
	 */
	public int getPeriod() { return period; }

	/**
	 * 直近期間を設定します。
	 * 
	 * @param period 直近期間
	 */
	public void setPeriod(final int period) { this.period = period; }

	/**
	 * ローソク足データを保持します。
	 */
	private Candlestick[] c;

	@Override
	public void prepare() {
		c = getDataset().getCandlestick();
	}

	@Override
	public boolean execute() {
		final int end = getCurrentDataIndex();
		final int start = Math.max(end - period + 1, getStartDataIndex());
		for (int i = start; i <= end; i++) {
			if (c[i] == null)
				return true;
		}
		return false;
	}

	@Override
	public void close() {
		c = null;
	}

}
