/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.order;

import java.util.Date;

/**
 * 成行注文情報の基底クラスを提供します。
 * 
 * @author 杉澤 浩二
 */
abstract class AbstractMarketOrder extends AbstractOrder implements MarketOrder {

	private static final long serialVersionUID = 5479077766301812735L;

	/**
	 * デフォルトコンストラクタです。
	 */
	protected AbstractMarketOrder() {}

	/**
	 * コンストラクタです。
	 * 
	 * @param symbol シンボル
	 * @param label ラベル
	 * @param date 注文日時
	 * @param quantity 数量
	 * @param findId 決済注文ID
	 * @param findLabel 決済注文ラベル
	 * @throws NullPointerException パラメーターに <code>null</code> を指定した場合
	 */
	protected AbstractMarketOrder(
			final String symbol,
			final String label,
			final Date date,
			final int quantity,
			final Integer findId,
			final String findLabel)
	{
		super(symbol, label, date, quantity, findId, findLabel);
	}

	/**
	 * 実装は必ず {@link OrderType#MARKET} を返します。
	 */
	@Override public final OrderType getOrderType() { return OrderType.MARKET; }

}
