/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.util;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.junit.Test;

/**
 * {@link DateArrayUtils} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class DateArrayUtilsTest {

	@Test
	public void testIndexOfDateArrayDate() throws ParseException {
		final SimpleDateFormat ymd = new SimpleDateFormat("yyyy/MM/dd");
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.indexOf(new Date[]{ ymd.parse("2000/01/01"), null, ymd.parse("2000/01/02"), ymd.parse("2000/01/03") }, ymd.parse("2000/01/02")), is(2));
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.indexOf(new Date[]{ ymd.parse("2000/01/01"), null, ymd.parse("2000/01/02"), ymd.parse("2000/01/03") }, null), is(1));
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.indexOf(null, ymd.parse("2000/01/02")), is(ArrayUtils.INDEX_NOT_FOUND));
	}

	@Test
	public void testIndexOfDateArrayDateInt() throws ParseException {
		final SimpleDateFormat ymd = new SimpleDateFormat("yyyy/MM/dd");
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.indexOf(new Date[]{ ymd.parse("2000/01/01"), null, ymd.parse("2000/01/02"), ymd.parse("2000/01/03") }, ymd.parse("2000/01/02"), 2), is(2));
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.indexOf(new Date[]{ ymd.parse("2000/01/01"), null, ymd.parse("2000/01/02"), ymd.parse("2000/01/03") }, null, 2), is(ArrayUtils.INDEX_NOT_FOUND));
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.indexOf(null, ymd.parse("2000/01/02"), 2), is(ArrayUtils.INDEX_NOT_FOUND));
	}

	@Test
	public void testLastIndexOfDateArrayDate() throws ParseException {
		final SimpleDateFormat ymd = new SimpleDateFormat("yyyy/MM/dd");
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.lastIndexOf(new Date[]{ ymd.parse("2000/01/01"), null, ymd.parse("2000/01/02"), ymd.parse("2000/01/03") }, ymd.parse("2000/01/02")), is(2));
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.lastIndexOf(new Date[]{ ymd.parse("2000/01/01"), null, ymd.parse("2000/01/02"), ymd.parse("2000/01/03") }, null), is(1));
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.lastIndexOf(null, ymd.parse("2000/01/02")), is(ArrayUtils.INDEX_NOT_FOUND));
	}

	@Test
	public void testLastIndexOfDateArrayDateInt() throws ParseException {
		final SimpleDateFormat ymd = new SimpleDateFormat("yyyy/MM/dd");
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.lastIndexOf(new Date[]{ ymd.parse("2000/01/01"), null, ymd.parse("2000/01/02"), ymd.parse("2000/01/03") }, ymd.parse("2000/01/02"), 1), is(0));
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.lastIndexOf(new Date[]{ ymd.parse("2000/01/01"), null, ymd.parse("2000/01/02"), ymd.parse("2000/01/03") }, null, 1), is(1));
		// Arrange + Act + Assert
		assertThat(DateArrayUtils.lastIndexOf(null, ymd.parse("2000/01/02"), 1), is(ArrayUtils.INDEX_NOT_FOUND));
	}

}
