/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.candle.generator;

import static jp.sf.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.DOJI;
import static jp.sf.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.FAR;
import static jp.sf.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.LONG_BODY;
import static jp.sf.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.LONG_SHADOW;
import static jp.sf.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.NEAR;
import static jp.sf.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.NO_SHADOW;
import static jp.sf.orangesignal.ta.candle.generator.CandlestickGeneratorSettingType.SAME;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import java.util.EnumMap;
import java.util.Map;

import jp.sf.orangesignal.ta.candle.generator.CandlestickGeneratorSetting.Range;

import org.junit.Test;

/**
 * {@link DefaultCandlestickGeneratorSettings} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class DefaultCandlestickGeneratorSettingsTest {

	private static final Map<CandlestickGeneratorSettingType, CandlestickGeneratorSetting> settings = new EnumMap<CandlestickGeneratorSettingType, CandlestickGeneratorSetting>(CandlestickGeneratorSettingType.class);

	static {
		settings.put(LONG_BODY, new CandlestickGeneratorSetting(Range.BODY, 1.0));
		settings.put(DOJI, new CandlestickGeneratorSetting(Range.BODY, 0.1));
		settings.put(LONG_SHADOW, new CandlestickGeneratorSetting(Range.BODY, 1.0));
		settings.put(NO_SHADOW, new CandlestickGeneratorSetting(Range.CANDLE, 0.1));
		settings.put(SAME, new CandlestickGeneratorSetting(Range.CANDLE, 0.05));
		settings.put(NEAR, new CandlestickGeneratorSetting(Range.CANDLE, 0.2));
		settings.put(FAR, new CandlestickGeneratorSetting(Range.CANDLE, 0.6));
	}

	@Test
	public void インスタンス化成功() {
		final DefaultCandlestickGeneratorSettings o = new DefaultCandlestickGeneratorSettings(settings, 10, 5);
		assertThat(o.getSettings(), is(settings));
	}

	@Test(expected = NullPointerException.class)
	public void コンストラクタ_settings_null() {
		new DefaultCandlestickGeneratorSettings(null, 10, 5);
	}

	@Test(expected = IllegalArgumentException.class)
	public void コンストラクタ_lengthPeriod_不正1() {
		new DefaultCandlestickGeneratorSettings(settings, 0, 5);
	}

	@Test(expected = IllegalArgumentException.class)
	public void コンストラクタ_lengthPeriod_不正2() {
		new DefaultCandlestickGeneratorSettings(settings, -1, 5);
	}

	@Test(expected = IllegalArgumentException.class)
	public void コンストラクタ_distancePeriod_不正1() {
		new DefaultCandlestickGeneratorSettings(settings, 10, 0);
	}

	@Test(expected = IllegalArgumentException.class)
	public void コンストラクタ_distancePeriod_不正2() {
		new DefaultCandlestickGeneratorSettings(settings, 10, -1);
	}

}
