/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data.model;

/**
 * 相場価格データのモデルクラスを提供します。
 * 
 * @author 杉澤 浩二
 * @since 2.2.1
 */
public class Quote extends Price {

	/**
	 * シンボルを保持します。
	 */
	private String symbol;

	/**
	 * シンボル名を保持します。
	 */
	private String symbolName;

	/**
	 * 売り気配値を保持します。
	 */
	private Number bid;

	/**
	 * 買い気配値を保持します。
	 */
	private Number ask;

	/**
	 * 前日比(値幅)を保持します。
	 */
	private Number change;

	/**
	 * デフォルトコンストラクタです。
	 */
	public Quote() {}

	/**
	 * シンボルを返します。
	 * 
	 * @return シンボル
	 */
	public String getSymbol() { return symbol; }

	/**
	 * シンボルを設定します。
	 * 
	 * @param symbol シンボル
	 */
	public void setSymbol(final String symbol) { this.symbol = symbol; }

	/**
	 * シンボル名を返します。シンボル名が不明な場合は <code>null</code> を返します。
	 * 
	 * @return シンボル名。または <code>null</code>
	 */
	public String getSymbolName() { return symbolName; }

	/**
	 * シンボル名を設定します。
	 * 
	 * @param symbolName シンボル名
	 */
	public void setSymbolName(final String symbolName) { this.symbolName = symbolName; }

	/**
	 * 売り気配値を返します。売り気配値が不明な場合は <code>null</code> を返します。
	 * 
	 * @return 売り気配値。または <code>null</code>
	 */
	public Number getBid() { return bid; }

	/**
	 * 売り気配値を設定します。
	 * 
	 * @param bid 売り気配値
	 */
	public void setBid(final Number bid) { this.bid = bid; }

	/**
	 * 買い気配値を返します。買い気配値が不明な場合は <code>null</code> を返します。
	 * 
	 * @return 買い気配値。または <code>null</code>
	 */
	public Number getAsk() { return ask; }

	/**
	 * 買い気配値を設定します。
	 * 
	 * @param ask 買い気配値
	 */
	public void setAsk(final Number ask) { this.ask = ask; }

	/**
	 * 前日比(値幅)を返します。取組がない場合や前日比計算をサポートしていない場合は <code>null</code> を返します。
	 * 
	 * @return 前日比(値幅)。または <code>null</code>
	 */
	public Number getChange() { return change; }

	/**
	 * 前日比(値幅)を設定します。
	 * 
	 * @param change 前日比(値幅)
	 */
	public void setChange(final Number change) { this.change = change; }

}
