/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data;

import java.io.Serializable;
import java.util.Locale;
import java.util.TimeZone;

import jp.sf.orangesignal.ta.util.Assert;

/**
 * 日時書式文字列情報を提供します。
 * 
 * @author 杉澤 浩二
 * @since 2.1
 */
public class DateFormatConfig implements Serializable {

	private static final long serialVersionUID = -9166996851666915817L;

	/**
	 * デフォルトコンストラクタです。
	 */
	protected DateFormatConfig() {}

	/**
	 * コンストラクタです。
	 * 
	 * @param pattern 日時書式文字列
	 * @param locale 地域情報
	 * @param zone タイムゾーン
	 */
	public DateFormatConfig(final String pattern, final Locale locale, final TimeZone zone) {
		Assert.notEmpty(pattern, "Pattern must not be empty");
		this.pattern = pattern;
		this.locale = locale;
		this.timeZone = zone;
	}

	/**
	 * 日時書式文字列を保持します。
	 */
	private String pattern;

	/**
	 * 日時書式文字列を返します。
	 * 
	 * @return 日時書式文字列
	 */
	public String getPattern() { return pattern; }

	/**
	 * 地域情報を保持します。
	 */
	private Locale locale;

	/**
	 * 地域情報を返します。
	 * 
	 * @return 地域情報
	 */
	public Locale getLocale() { return locale; }

	/**
	 * タイムゾーンを保持します。
	 */
	private TimeZone timeZone;

	/**
	 * タイムゾーンを返します。
	 * 
	 * @return タイムゾーン
	 */
	public TimeZone getTimeZone() { return timeZone; }

}
