/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.event;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThat;

import java.awt.Point;

import org.junit.Test;

/**
 * {@link ChartScreenEvent} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class ChartScreenEventTest {

	@Test
	public void testChartScreenEventObjectPointIntIntInt() {
		// Act
		final ChartScreenEvent event = new ChartScreenEvent(this, null, 10, 256, 0);
		// Assert
		assertEquals(event.getSource(), this);
	}

	@Test
	public void testChartScreenEventObjectPointIntIntIntObject() {
		// Act
		final ChartScreenEvent event = new ChartScreenEvent(this, null, 10, 256, 0, null);
		// Assert
		assertEquals(event.getSource(), this);
	}

	@Test
	public void testGetMousePosition() {
		// Arrange
		final Point point = new Point(50, 80);
		final ChartScreenEvent event = new ChartScreenEvent(this, point, 10, 256, 0);
		// Act + Assert
		assertEquals(event.getMousePosition(), point);
	}

	@Test
	public void testGetStart() {
		// Arrange
		final ChartScreenEvent event = new ChartScreenEvent(this, null, 10, 256, 0, null);
		// Act + Assert
		assertThat(event.getStart(), is(10));
	}

	@Test
	public void testGetPeriod() {
		// Arrange
		final ChartScreenEvent event = new ChartScreenEvent(this, null, 10, 256, 0, null);
		// Act + Assert
		assertThat(event.getPeriod(), is(256));
	}

	@Test
	public void testGetPosition() {
		// Arrange
		final ChartScreenEvent event = new ChartScreenEvent(this, null, 10, 256, 0, null);
		// Act + Assert
		assertThat(event.getPosition(), is(0));
	}

	@Test
	public void testGetInfo() {
		// Arrange
		final Object obj = new Object();
		final ChartScreenEvent event = new ChartScreenEvent(this, null, 10, 256, 0, obj);
		// Act + Assert
		assertEquals(event.getInfo(), obj);
	}

}
