/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.unit;

import java.io.Serializable;

/**
 * 値幅単位情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public class PriceUnit implements Serializable, Comparable<PriceUnit> {

	private static final long serialVersionUID = 6286874102236053319L;

	/**
	 * 価格を保持します。
	 */
	private int price;

	/**
	 * 値幅を保持します。
	 */
	private double point;

	/**
	 * コンストラクタです。
	 * 
	 * @param price 価格
	 * @param point 値幅
	 */
	public PriceUnit(final int price, final double point) {
		this.price = price;
		this.point = point;
	}

	/**
	 * 価格を返します。
	 * 
	 * @return 価格
	 */
	public int getPrice() { return price; }

	/**
	 * 値幅を返します。
	 * 
	 * @return 値幅
	 */
	public double getPoint() { return point; }

	@Override
	public int compareTo(final PriceUnit o) {
		if (price < o.price) {
			return 1;
		} else if (price > o.price) {
			return -1;
		} else {
			return 0;
		}
	}

}
