/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import jp.sf.orangesignal.chart.util.StringManager;

/**
 * 出来高分析指標の種類を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum VolumeType {

	/**
	 * (なし)を表します。
	 */
	NONE { @Override public String toString() { return StringManager.getString("volume.none"); } },

	/**
	 * 出来高を表します。
	 */
	VOLUME { @Override public String toString() { return StringManager.getString("volume.volume"); } },

	/**
	 * 出来高＋信用残を表します。
	 */
	MARGIN { @Override public String toString() { return StringManager.getString("volume.margin"); } },

	/**
	 * 出来高＋移動平均線を表します。
	 */
	MOVING_AVERAGE { @Override public String toString() { return StringManager.getString("volume.ma"); } };

}
