/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import jp.sf.orangesignal.ta.util.Assert;

public abstract class JaHolidayUtils {
    private static final Calendar FUNERAL_CEREMONY_OF_EMPEROR_SHOWA = JaHolidayUtils.getCalendar();
    private static final Calendar CEREMONY_OF_THE_ENTHRONEMENT;
    private static final Calendar RITE_OF_WEDDING_OF_HIH_CROWN_PRINCE_NARUHITO;
    private static final double FRACTION = 0.242194;

    private static Calendar getCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("Asia/Tokyo"));
    }

    private static void truncateTime(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    public static boolean isHoliday(Date date) {
        Calendar c = JaHolidayUtils.getCalendar();
        c.setTime(date);
        JaHolidayUtils.truncateTime(c);
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        int dayofweek = c.get(7);
        switch (month) {
            case 0: {
                if (day == 1) {
                    return true;
                }
                if (!(year >= 2000 ? c.get(8) == 2 && dayofweek == 2 : day == 15)) break;
                return true;
            }
            case 1: {
                if (day != 11) break;
                return true;
            }
            case 2: {
                if (day != JaHolidayUtils.getVernalEquinoxDay(year)) break;
                return true;
            }
            case 3: {
                if (day != 29) break;
                return true;
            }
            case 4: {
                if (day == 3) {
                    return true;
                }
                if (year >= 1986 && day == 4) {
                    return true;
                }
                if (day != 5) break;
                return true;
            }
            case 6: {
                if (year < 1996 || !(year >= 2003 ? c.get(8) == 3 && dayofweek == 2 : day == 20)) break;
                return true;
            }
            case 8: {
                if (year >= 2003 ? c.get(8) == 3 && dayofweek == 2 : day == 15) {
                    return true;
                }
                if (day != JaHolidayUtils.getAutumnalEquinoxDay(year)) break;
                return true;
            }
            case 9: {
                if (!(year >= 2000 ? c.get(8) == 2 && dayofweek == 2 : day == 10)) break;
                return true;
            }
            case 10: {
                if (day == 3) {
                    return true;
                }
                if (day != 23) break;
                return true;
            }
            case 11: {
                if (year < 1989 || day != 23) break;
                return true;
            }
        }
        if (c.compareTo(FUNERAL_CEREMONY_OF_EMPEROR_SHOWA) == 0) {
            return true;
        }
        if (c.compareTo(CEREMONY_OF_THE_ENTHRONEMENT) == 0) {
            return true;
        }
        return c.compareTo(RITE_OF_WEDDING_OF_HIH_CROWN_PRINCE_NARUHITO) == 0;
    }

    public static strictfp int getVernalEquinoxDay(int year) {
        Assert.isFalse((year > 2150 ? 1 : 0) != 0);
        if (year >= 2100) {
            return (int)(21.851 + 0.242194 * (double)(year - 1980) - (double)((year - 1980) / 4));
        }
        if (year >= 1980) {
            return (int)(20.8431 + 0.242194 * (double)(year - 1980) - (double)((year - 1980) / 4));
        }
        if (year >= 1900) {
            return (int)(20.8357 + 0.242194 * (double)(year - 1980) - (double)((year - 1983) / 4));
        }
        if (year >= 1851) {
            return (int)(19.8277 + 0.242194 * (double)(year - 1980) - (double)((year - 1983) / 4));
        }
        throw new IllegalArgumentException();
    }

    public static strictfp int getAutumnalEquinoxDay(int year) {
        Assert.isFalse((year > 2150 ? 1 : 0) != 0);
        if (year >= 2100) {
            return (int)(24.2488 + 0.242194 * (double)(year - 1980) - (double)((year - 1980) / 4));
        }
        if (year >= 1980) {
            return (int)(23.2488 + 0.242194 * (double)(year - 1980) - (double)((year - 1980) / 4));
        }
        if (year >= 1900) {
            return (int)(23.2588 + 0.242194 * (double)(year - 1980) - (double)((year - 1983) / 4));
        }
        if (year >= 1851) {
            return (int)(22.2588 + 0.242194 * (double)(year - 1980) - (double)((year - 1983) / 4));
        }
        throw new IllegalArgumentException();
    }

    public static boolean isClosed(Date date) {
        Calendar c = JaHolidayUtils.getCalendar();
        c.setTime(date);
        int month = c.get(2);
        int day = c.get(5);
        switch (month) {
            case 0: {
                if (day != 1 && day != 2 && day != 3) break;
                return true;
            }
            case 11: {
                if (day != 31) break;
                return true;
            }
        }
        return false;
    }

    static {
        FUNERAL_CEREMONY_OF_EMPEROR_SHOWA.set(1989, 1, 24);
        JaHolidayUtils.truncateTime(FUNERAL_CEREMONY_OF_EMPEROR_SHOWA);
        CEREMONY_OF_THE_ENTHRONEMENT = JaHolidayUtils.getCalendar();
        CEREMONY_OF_THE_ENTHRONEMENT.set(1990, 10, 12);
        JaHolidayUtils.truncateTime(CEREMONY_OF_THE_ENTHRONEMENT);
        RITE_OF_WEDDING_OF_HIH_CROWN_PRINCE_NARUHITO = JaHolidayUtils.getCalendar();
        RITE_OF_WEDDING_OF_HIH_CROWN_PRINCE_NARUHITO.set(1993, 5, 9);
        JaHolidayUtils.truncateTime(RITE_OF_WEDDING_OF_HIH_CROWN_PRINCE_NARUHITO);
    }
}

