/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.screen;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.MAType;
import jp.sf.orangesignal.chart.ui.canvas.IndexCanvas;
import jp.sf.orangesignal.chart.ui.screen.SideScreen;
import jp.sf.orangesignal.chart.util.StringManager;

public class AntiWatchSideScreen
extends SideScreen
implements ItemListener {
    private static final long serialVersionUID = -6148675225780002493L;
    private final IndexCanvas canvas;
    private final JCheckBox fixed = new JCheckBox(StringManager.getString("fixed", new Object[0]));
    private final JCheckBox marker = new JCheckBox(StringManager.getString("marker.signal", new Object[0]));
    private final JComboBox maType = AntiWatchSideScreen.createMovingAverageJComboBox();
    private final JSpinner maPeriod = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));

    public AntiWatchSideScreen(Icons icons) {
        this.canvas = new IndexCanvas(icons);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(layout);
        int y = 0;
        this.addCanvas(layout, c, y++, this.canvas);
        this.addCheckBox(layout, c, y++, this.fixed);
        this.addCheckBox(layout, c, y++, this.marker);
        this.addSeparator(layout, c, y++);
        this.addPanel(layout, c, y, this.createMaPanel());
    }

    private JPanel createMaPanel() {
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(layout);
        int y = 0;
        this.addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype", new Object[0])), this.maType);
        this.addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period", new Object[0])), this.maPeriod);
        return panel;
    }

    @Override
    public void load(ChartSettings settings) {
        this.setVisibleAdvancedOptions(settings.advancedOptions);
        ChartSettings.AntiWatchSettings s = settings.antiwatch;
        this.fixed.setSelected(s.fixed);
        this.marker.setSelected(s.signalMarker);
        this.maType.setSelectedItem((Object)s.maType);
        this.maPeriod.setValue(s.maPeriod);
    }

    @Override
    public void save(ChartSettings settings) {
        ChartSettings.AntiWatchSettings s = settings.antiwatch;
        s.fixed = this.fixed.isSelected();
        s.signalMarker = this.marker.isSelected();
        s.maType = (MAType)((Object)this.maType.getSelectedItem());
        s.maPeriod = (Integer)this.maPeriod.getValue();
    }

    public boolean isIgnoreStart(ChartSettings settings) {
        ChartSettings.AntiWatchSettings s = settings.antiwatch;
        return s.maPeriod == (Integer)this.maPeriod.getValue();
    }

    @Override
    public void datasetSwitch(ChartEvent e) {
        this.notify = false;
        boolean enabled = e.getDataset() != null;
        this.fixed.setEnabled(enabled);
        this.marker.setEnabled(enabled);
        this.maType.setEnabled(enabled);
        this.maPeriod.setEnabled(enabled);
        if (enabled) {
            this.load(e.getSettings());
        }
        this.canvas.switchDataset(e);
        this.notify = true;
    }

    @Override
    public void periodSwitch(ChartEvent e) {
        this.canvas.switchDataset(e);
    }

    @Override
    public void settingChanged(ChartEvent e) {
        this.canvas.switchDataset(e);
    }

    @Override
    public void positionChanged(ChartScreenEvent e) {
        this.canvas.setup(e);
    }

    @Override
    public void setVisibleAdvancedOptions(boolean visible) {
        this.fixed.setVisible(visible);
    }
}

