/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.data.loader;

import java.applet.Applet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import jp.sf.orangesignal.chart.data.BasicChartDataset;
import jp.sf.orangesignal.chart.data.loader.ChartDataLoader;
import jp.sf.orangesignal.chart.data.loader.Margin;
import jp.sf.orangesignal.chart.data.loader.Price;
import jp.sf.orangesignal.chart.data.loader.RuntimeIOException;
import jp.sf.orangesignal.chart.data.loader.Split;
import jp.sf.orangesignal.chart.event.DataLoadEvent;
import jp.sf.orangesignal.ta.util.StringUtils;
import netscape.javascript.JSObject;

public class JSChartDataLoader
extends ChartDataLoader {
    public static final String DEFAULT_PRICE_KEY = "_price";
    public static final String DEFAULT_MARGIN_KEY = "_margin";
    public static final String DEFAULT_SPLIT_KEY = "_split";
    public static final String DEFAULT_LINE_SEPARATOR = "\n";
    public static final String DEFAULT_ITEM_SEPARATOR = ",";
    public static final String DEFAULT_DATE_FORMAT_PATTERN = "yyyyMMdd";
    private String priceKey = "_price";
    private String marginKey = "_margin";
    private String splitKey = "_split";
    private String lineSeparator = "\n";
    private String itemSeparator = ",";
    private String dateFormatPattern = "yyyyMMdd";

    public String getPriceKey() {
        return this.priceKey;
    }

    public void setPriceKey(String priceKey) {
        this.priceKey = priceKey;
    }

    public String getMarginKey() {
        return this.marginKey;
    }

    public void setMarginKey(String marginKey) {
        this.marginKey = marginKey;
    }

    public String getSplitKey() {
        return this.splitKey;
    }

    public void setSplitKey(String splitKey) {
        this.splitKey = splitKey;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public String getItemSeparator() {
        return this.itemSeparator;
    }

    public void setItemSeparator(String itemSeparator) {
        this.itemSeparator = itemSeparator;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    @Override
    public void load(Applet applet) {
        JSObject window = JSObject.getWindow((Applet)applet);
        BasicChartDataset dataset = BasicChartDataset.createDataset(this.getPrice(window), this.getMargin(window), this.getSplit(window), null);
        super.send(new DataLoadEvent(this, dataset));
    }

    protected List<Price> getPrice(JSObject window) {
        String[] lines = this.getData(window, this.priceKey);
        if (lines == null) {
            return new ArrayList<Price>(0);
        }
        SimpleDateFormat parser = new SimpleDateFormat(this.dateFormatPattern);
        ArrayList<Price> results = new ArrayList<Price>(lines.length);
        try {
            for (String line : lines) {
                long volume;
                double close;
                double low;
                double high;
                String[] items = line.split(this.itemSeparator);
                Price price = new Price();
                price.date = parser.parse(items[0]);
                double open = Double.parseDouble(items[1]);
                if (open > 0.0) {
                    price.open = open;
                }
                if ((high = Double.parseDouble(items[2])) > 0.0) {
                    price.high = high;
                }
                if ((low = Double.parseDouble(items[3])) > 0.0) {
                    price.low = low;
                }
                if ((close = Double.parseDouble(items[4])) > 0.0) {
                    price.close = close;
                }
                if ((volume = Long.parseLong(items[5])) > 0L) {
                    price.volume = volume;
                }
                results.add(price);
            }
        }
        catch (ParseException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
        catch (NumberFormatException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
        return results;
    }

    protected List<Margin> getMargin(JSObject window) {
        String[] lines = this.getData(window, this.marginKey);
        if (lines == null) {
            return new ArrayList<Margin>(0);
        }
        SimpleDateFormat parser = new SimpleDateFormat(this.dateFormatPattern);
        ArrayList<Margin> results = new ArrayList<Margin>(lines.length);
        try {
            for (String line : lines) {
                double bought;
                String[] items = line.split(this.itemSeparator);
                Margin margin = new Margin();
                margin.date = parser.parse(items[0]);
                double sold = Double.parseDouble(items[1]);
                if (sold > 0.0) {
                    margin.sold = sold;
                }
                if ((bought = Double.parseDouble(items[2])) > 0.0) {
                    margin.bought = bought;
                }
                results.add(margin);
            }
        }
        catch (ParseException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
        catch (NumberFormatException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
        return results;
    }

    protected List<Split> getSplit(JSObject window) {
        String[] lines = this.getData(window, this.splitKey);
        if (lines == null) {
            return new ArrayList<Split>(0);
        }
        SimpleDateFormat parser = new SimpleDateFormat(this.dateFormatPattern);
        ArrayList<Split> results = new ArrayList<Split>(lines.length);
        try {
            for (String line : lines) {
                String[] items = line.split(this.itemSeparator);
                Split split = new Split();
                split.date = parser.parse(items[0]);
                split.split = Double.parseDouble(items[1]);
                results.add(split);
            }
        }
        catch (ParseException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
        catch (NumberFormatException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
        return results;
    }

    protected String[] getData(JSObject window, String key) {
        String data = JSChartDataLoader.getMember(window, key);
        if (StringUtils.isEmpty((String)data)) {
            return null;
        }
        return data.split(this.lineSeparator);
    }

    public static String getMember(JSObject window, String key) {
        try {
            String result = (String)window.getMember(key);
            if (StringUtils.isEmpty((String)result) || "undefined".equalsIgnoreCase(result)) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }
}

