/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.data;

import java.util.Date;
import java.util.List;
import java.util.Map;
import jp.sf.orangesignal.chart.data.ChartDataset;
import jp.sf.orangesignal.chart.data.loader.Margin;
import jp.sf.orangesignal.chart.data.loader.Price;
import jp.sf.orangesignal.chart.data.loader.Split;
import jp.sf.orangesignal.chart.ui.DatasetType;
import jp.sf.orangesignal.ta.TechnicalAnalysis;
import jp.sf.orangesignal.ta.data.CompressType;
import jp.sf.orangesignal.ta.data.DataConvertUtils;
import jp.sf.orangesignal.ta.data.DatasetItems;
import jp.sf.orangesignal.ta.data.DatasetSource;
import jp.sf.orangesignal.ta.data.MergeGapFillType;
import jp.sf.orangesignal.ta.data.MergeMatchType;
import jp.sf.orangesignal.ta.data.annotation.AnnotationParser;
import jp.sf.orangesignal.ta.data.annotation.DateItem;
import jp.sf.orangesignal.ta.data.annotation.NumberCompressorType;
import jp.sf.orangesignal.ta.data.annotation.NumberItem;
import jp.sf.orangesignal.ta.result.FourPrice;
import jp.sf.orangesignal.ta.util.ArrayUtils;

public class BasicChartDataset
implements ChartDataset {
    @DateItem
    public Date[] date;
    @NumberItem
    @NumberCompressorType(value=CompressType.FIRST)
    public Number[] open;
    @NumberItem
    @NumberCompressorType(value=CompressType.HIGHEST)
    public Number[] high;
    @NumberItem
    @NumberCompressorType(value=CompressType.LOWEST)
    public Number[] low;
    @NumberItem
    @NumberCompressorType(value=CompressType.LAST)
    public Number[] close;
    public Number[] change;
    public Number[] percentChange;
    @NumberItem
    @NumberCompressorType(value=CompressType.SUM)
    public Number[] volume;
    @NumberItem
    @NumberCompressorType(value=CompressType.SUM)
    public Number[] sold;
    @NumberItem
    @NumberCompressorType(value=CompressType.SUM)
    public Number[] bought;
    public Number[] ratio;
    @NumberItem
    @NumberCompressorType(value=CompressType.SUM)
    public Number[] split;
    public Number[] techOpen;
    public Number[] techHigh;
    public Number[] techLow;
    public Number[] techClose;
    public Number[] techChange;
    public Number[] techVolume;

    public BasicChartDataset() {
    }

    protected BasicChartDataset(BasicChartDataset dataset) {
        this.date = (Date[])ArrayUtils.clone((Object[])dataset.date);
        this.open = (Number[])ArrayUtils.clone((Object[])dataset.open);
        this.high = (Number[])ArrayUtils.clone((Object[])dataset.high);
        this.low = (Number[])ArrayUtils.clone((Object[])dataset.low);
        this.close = (Number[])ArrayUtils.clone((Object[])dataset.close);
        this.change = (Number[])ArrayUtils.clone((Object[])dataset.change);
        this.percentChange = (Number[])ArrayUtils.clone((Object[])dataset.percentChange);
        this.volume = (Number[])ArrayUtils.clone((Object[])dataset.volume);
        this.sold = (Number[])ArrayUtils.clone((Object[])dataset.sold);
        this.bought = (Number[])ArrayUtils.clone((Object[])dataset.bought);
        this.ratio = (Number[])ArrayUtils.clone((Object[])dataset.ratio);
        this.split = (Number[])ArrayUtils.clone((Object[])dataset.split);
        this.techOpen = (Number[])ArrayUtils.clone((Object[])dataset.techOpen);
        this.techHigh = (Number[])ArrayUtils.clone((Object[])dataset.techHigh);
        this.techLow = (Number[])ArrayUtils.clone((Object[])dataset.techLow);
        this.techClose = (Number[])ArrayUtils.clone((Object[])dataset.techClose);
        this.techChange = (Number[])ArrayUtils.clone((Object[])dataset.techChange);
        this.techVolume = (Number[])ArrayUtils.clone((Object[])dataset.techVolume);
    }

    public static final BasicChartDataset createDataset(List<Price> prices, List<Margin> margin, List<Split> splits, List<Price> nikkei) {
        DatasetSource source = AnnotationParser.parse(prices);
        if (margin != null && margin.size() > 0) {
            source.merge(AnnotationParser.parse(margin), MergeMatchType.CURRENT, MergeGapFillType.PREVIOUS, null);
        }
        if (splits != null && splits.size() > 0) {
            source.merge(AnnotationParser.parse(splits), MergeMatchType.CURRENT);
        }
        BasicChartDataset result = (BasicChartDataset)source.build(BasicChartDataset.class).execute();
        result.setup();
        return result;
    }

    public final BasicChartDataset createDataset(DatasetType datasetType, boolean split) {
        BasicChartDataset dataset = new BasicChartDataset(this);
        if (split) {
            Map map = TechnicalAnalysis.split((Number[])dataset.open, (Number[])dataset.high, (Number[])dataset.low, (Number[])dataset.close, (Number[])dataset.split);
            dataset.open = (Number[])map.get(FourPrice.OPEN);
            dataset.high = (Number[])map.get(FourPrice.HIGH);
            dataset.low = (Number[])map.get(FourPrice.LOW);
            dataset.close = (Number[])map.get(FourPrice.CLOSE);
        }
        DatasetItems source = (DatasetItems)AnnotationParser.parse((Object)dataset);
        if (datasetType == DatasetType.WEEKLY) {
            source.compress(7);
            Date[] base = (Date[])source.getUniqueDateEntry().getValue();
            source.setNumber("sold", DataConvertUtils.merge((Date[])base, (Date[])dataset.date, (Object[])dataset.sold).values().toArray(new Number[0]));
            source.setNumber("bought", DataConvertUtils.merge((Date[])base, (Date[])dataset.date, (Object[])dataset.bought).values().toArray(new Number[0]));
        } else if (datasetType == DatasetType.MONTHLY) {
            source.compress(5);
        }
        BasicChartDataset result = (BasicChartDataset)source.build(BasicChartDataset.class).execute();
        result.setup();
        return result;
    }

    private void setup() {
        this.change = TechnicalAnalysis.chg((Number[])this.close);
        this.percentChange = TechnicalAnalysis.pchg((Number[])this.close);
        this.ratio = TechnicalAnalysis.div((Number[])this.bought, (Number[])this.sold);
        this.techOpen = DataConvertUtils.previousIfNull((Number[])this.open);
        this.techHigh = DataConvertUtils.previousIfNull((Number[])this.high);
        this.techLow = DataConvertUtils.previousIfNull((Number[])this.low);
        this.techClose = DataConvertUtils.previousIfNull((Number[])this.close);
        this.techChange = TechnicalAnalysis.chg((Number[])this.techClose);
        this.techVolume = DataConvertUtils.zeroIfNull((Number[])this.volume);
    }

    public double getMaxHighLowAverage() {
        Number high = null;
        Number low = null;
        for (int i = 0; i < this.getCount(); ++i) {
            if (high == null) {
                high = this.high[i];
            } else if (this.high[i] != null && this.high[i].doubleValue() > high.doubleValue()) {
                high = this.high[i];
            }
            if (low == null) {
                low = this.low[i];
                continue;
            }
            if (this.low[i] == null || !(this.low[i].doubleValue() < low.doubleValue())) continue;
            low = this.low[i];
        }
        return (high.doubleValue() + low.doubleValue()) / 2.0;
    }

    @Override
    public int getCount() {
        return this.date == null ? 0 : this.date.length;
    }
}

