/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.axis;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import java.util.Date;
import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.axis.Axis;
import jp.sf.orangesignal.chart.axis.DateTickUnit;
import jp.sf.orangesignal.chart.axis.Orientation;
import jp.sf.orangesignal.chart.ui.DatasetType;
import jp.sf.orangesignal.chart.util.DrawUtils;
import jp.sf.orangesignal.chart.util.StringManager;

public class DateAxis
extends Axis {
    public static int MINIMUM_DRAW_WIDTH = 100;
    private DatasetType datasetType;
    private int period;
    private DateTickUnit tickUnit = DateTickUnit.ONE_MONTH;
    private boolean inside = false;

    public DateAxis() {
        this.setOrientation(Orientation.HORIZONTAL);
    }

    public void prepare(DatasetType datasetType, int period) {
        this.datasetType = datasetType;
        this.period = period;
    }

    public void setTickUnit(DateTickUnit tickUnit) {
        this.tickUnit = tickUnit;
    }

    public void setInside(boolean inside) {
        this.inside = inside;
    }

    @Override
    public void refreshTicks() {
        int size = this.period / this.getTickCount();
        if (this.datasetType == DatasetType.DAILY) {
            this.tickUnit = size > 200 ? DateTickUnit.ONE_YEAR : (size > 100 ? DateTickUnit.SIX_MONTH : (size > 50 ? DateTickUnit.THREE_MONTH : DateTickUnit.ONE_MONTH));
        } else if (this.datasetType == DatasetType.WEEKLY) {
            this.tickUnit = size > 40 ? DateTickUnit.ONE_YEAR : (size > 20 ? DateTickUnit.SIX_MONTH : (size > 10 ? DateTickUnit.THREE_MONTH : DateTickUnit.ONE_MONTH));
        } else if (this.datasetType == DatasetType.MONTHLY) {
            this.tickUnit = size > 10 ? DateTickUnit.ONE_YEAR : (size > 5 ? DateTickUnit.SIX_MONTH : ((double)size > 2.5 ? DateTickUnit.THREE_MONTH : DateTickUnit.ONE_MONTH));
        }
    }

    @Override
    public void refreshTicks(Graphics2D g2, Rectangle2D area) {
        int tickCount = (int)Math.ceil(Math.max(area.getWidth(), (double)MINIMUM_DRAW_WIDTH) / ((double)g2.getFontMetrics(FONT).stringWidth(String.format(StringManager.getString("format.date", new Object[0]), new Date())) * this.getGap()));
        this.setTickCount(tickCount);
        this.refreshTicks();
    }

    public void draw(Graphics2D g2, Rectangle2D area, double periodWidth, Date[] items, int start, int period) {
        this.draw(g2, area, new Rectangle2D[]{area}, periodWidth, items, start, period);
    }

    public void draw(Graphics2D g2, Rectangle2D area, Rectangle2D[] subareas, double periodWidth, Date[] items, int start, int period) {
        g2.setFont(FONT);
        double top = area.getMaxY() + (double)this.getTickMarkOutsideLength();
        Rectangle2D chart = subareas[0];
        if (items != null) {
            FontMetrics fm = g2.getFontMetrics();
            Calendar c = Calendar.getInstance();
            int previousMonth = 0;
            for (int i = -1; i < period; ++i) {
                int n = start + i;
                if (n < 0 || n >= items.length || items[n] == null) continue;
                c.setTime(items[n]);
                int month = c.get(2) + 1;
                if (previousMonth == month) continue;
                if (i != -1) {
                    double x;
                    if (this.tickUnit == DateTickUnit.ONE_MONTH && (month >= 1 && month <= 12 || n == 0)) {
                        x = chart.getMinX() + (double)i * periodWidth + periodWidth * 0.5;
                        this.draw(g2, fm, subareas, x, top, items[n]);
                    } else if (this.tickUnit == DateTickUnit.THREE_MONTH && (month == 1 || month == 4 || month == 7 || month == 10 || n == 0)) {
                        x = chart.getMinX() + (double)i * periodWidth + periodWidth * 0.5;
                        this.draw(g2, fm, subareas, x, top, items[n]);
                    } else if (this.tickUnit == DateTickUnit.SIX_MONTH && (month == 1 || month == 7 || n == 0)) {
                        x = chart.getMinX() + (double)i * periodWidth + periodWidth * 0.5;
                        this.draw(g2, fm, subareas, x, top, items[n]);
                    } else if (this.tickUnit == DateTickUnit.ONE_YEAR && (month == 1 || n == 0)) {
                        x = chart.getMinX() + (double)i * periodWidth;
                        if (!this.inside) {
                            x += periodWidth * 0.5;
                        }
                        this.draw(g2, fm, subareas, x, top, items[n]);
                    }
                }
                previousMonth = month;
            }
        }
        if (!this.inside) {
            this.drawAxisLine(g2, chart.getMinX(), top, chart.getMaxX(), top);
        }
    }

    private void draw(Graphics2D g2, FontMetrics fm, Rectangle2D[] areas, double x, double top, Date date) {
        for (Rectangle2D rect : areas) {
            if (rect == null) continue;
            this.drawGlidline(g2, x, rect.getMinY(), x, rect.getMaxY());
        }
        String label = this.tickUnit.valueToString(date);
        if (this.inside) {
            DrawUtils.drawText(g2, label, (float)x, (float)areas[areas.length - 1].getMaxY());
        } else {
            this.drawTickMark(g2, x, top, x, top + (double)this.getTickMarkInsideLength());
            DrawUtils.drawText(g2, label, (float)(x - (double)fm.stringWidth(label) * 0.5), (float)top + (float)this.getTickMarkInsideLength() + (float)fm.getAscent() + 1.0f);
        }
    }

    public void drawAxisTrace(Graphics2D g2, Rectangle2D area, double x, int margin, Date date) {
        this.drawTraceLine(g2, x, area.getMinY(), x, area.getMaxY());
        if (date == null) {
            return;
        }
        g2.setFont(FONT);
        FontMetrics fm = g2.getFontMetrics();
        String text = String.format(StringManager.getString("format.date", new Object[0]), date);
        double top = area.getMaxY() + (double)this.getTickMarkOutsideLength();
        int width = fm.stringWidth(text);
        int height = fm.getHeight();
        double x1 = x - (double)width * 0.5;
        double x2 = x + (double)width * 0.5;
        double y1 = top + (double)this.getTickMarkInsideLength() + 1.0;
        double y2 = top + (double)this.getTickMarkInsideLength() + (double)g2.getFontMetrics().getHeight() + 1.0;
        GeneralPath path = new GeneralPath();
        path.moveTo((float)(x1 - (double)margin), (float)y2);
        path.lineTo((float)(x1 - (double)margin), (float)y1);
        path.lineTo((float)(x1 + (x2 - x1) * 0.5 - (double)height * 0.5), (float)y1);
        path.lineTo((float)(x1 + (x2 - x1) * 0.5), (float)(top - (double)margin));
        path.lineTo((float)(x1 + (x2 - x1) * 0.5 + (double)height * 0.5), (float)y1);
        path.lineTo((float)(x2 + (double)margin), (float)y1);
        path.lineTo((float)(x2 + (double)margin), (float)y2);
        path.closePath();
        g2.setPaint(new GradientPaint((float)x1, (float)top, Color.WHITE, (float)x1, (float)y2, ChartColor.VERY_LIGHT_GRAY));
        g2.fill(path);
        g2.setColor(Color.BLUE);
        g2.draw(path);
        double y = top + (double)this.getTickMarkInsideLength() + (double)fm.getAscent() + 1.0;
        DrawUtils.drawText(g2, text, (float)x1, (float)y);
    }
}

