/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.FontConstants;
import jp.sf.orangesignal.chart.axis.Orientation;
import jp.sf.orangesignal.chart.util.StringManager;

public abstract class Axis {
    public static final int DEFAULT_TICK_COUNT = 2;
    public static final double DEFAULT_GAP = 2.0;
    public static final Font FONT = FontConstants.FONT_INDEX_SMALL;
    public static final int DEFAULT_TICK_MARK_OUTSIDE_LENGTH = 4;
    public static final int DEFAULT_TICK_MARK_INSIDE_LENGTH = 3;
    public static final int DEFAULT_TICK_WIDTH_MARGIN = 2;
    private Orientation orientation = Orientation.VERTICAL;
    private int tickCount = 2;
    private double gap = 2.0;
    private int tickMarkOutsideLength = 4;
    private int tickMarkInsideLength = 3;
    private int tickWidthMargin = 2;
    private Color glidlineColor = ChartColor.LIGHT_GRAY;
    private Stroke glidlineStroke = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, 0.0f);
    private Color tickMarkLineColor = Color.BLACK;
    private Stroke tickMarkLineStroke = new BasicStroke(1.0f, 0, 0);

    protected Axis() {
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double gap) {
        this.gap = gap;
    }

    public int getTickMarkOutsideLength() {
        return this.tickMarkOutsideLength;
    }

    public void setTickMarkOutsideLength(int length) {
        this.tickMarkOutsideLength = length;
    }

    public int getTickMarkInsideLength() {
        return this.tickMarkInsideLength;
    }

    public void setTickMarkInsideLength(int length) {
        this.tickMarkInsideLength = length;
    }

    public int getTickWidthMargin() {
        return this.tickWidthMargin;
    }

    public void setTickWidthMargin(int tickWidthMargin) {
        this.tickWidthMargin = tickWidthMargin;
    }

    public Color getGlidlineColor() {
        return this.glidlineColor;
    }

    public void setGlidlineColor(Color color) {
        this.glidlineColor = color;
    }

    public Stroke getGlidlineStroke() {
        return this.glidlineStroke;
    }

    public void setGlidlineStroke(Stroke stroke) {
        this.glidlineStroke = stroke;
    }

    public Color getTickMarkLineColor() {
        return this.tickMarkLineColor;
    }

    public void setTickMarkLineColor(Color color) {
        this.tickMarkLineColor = color;
    }

    public Stroke getTickMarkLineStroke() {
        return this.tickMarkLineStroke;
    }

    public void setTickMarkLineStroke(Stroke stroke) {
        this.tickMarkLineStroke = stroke;
    }

    protected int getBaseTickWidth() {
        return this.tickMarkOutsideLength + this.tickMarkInsideLength + this.tickWidthMargin;
    }

    public int getSpace(Graphics g) {
        FontMetrics fm = g.getFontMetrics(FONT);
        if (this.orientation == Orientation.VERTICAL) {
            return fm.stringWidth(StringManager.getString("axis.sample", new Object[0])) + this.getBaseTickWidth();
        }
        if (this.orientation == Orientation.HORIZONTAL) {
            return fm.getHeight() + this.getBaseTickWidth();
        }
        throw new RuntimeException();
    }

    protected void drawGlidline(Graphics2D g2, double x1, double y1, double x2, double y2) {
        g2.setColor(this.glidlineColor);
        g2.setStroke(this.glidlineStroke);
        g2.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    protected void drawAxisLine(Graphics2D g2, double x1, double y1, double x2, double y2) {
        g2.setColor(this.tickMarkLineColor);
        g2.setStroke(this.tickMarkLineStroke);
        g2.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    protected void drawTickMark(Graphics2D g2, double x1, double y1, double x2, double y2) {
        g2.setColor(this.tickMarkLineColor);
        g2.setStroke(this.tickMarkLineStroke);
        g2.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    protected void drawTraceLine(Graphics2D g2, double x1, double y1, double x2, double y2) {
        g2.setXORMode(Color.ORANGE);
        g2.setStroke(this.tickMarkLineStroke);
        g2.draw(new Line2D.Double(x1, y1, x2, y2));
        g2.setPaintMode();
    }

    public abstract void refreshTicks();

    public abstract void refreshTicks(Graphics2D var1, Rectangle2D var2);
}

