/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart;

import java.applet.Applet;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.FontConstants;
import jp.sf.orangesignal.chart.data.AntiWatchChartDataset;
import jp.sf.orangesignal.chart.data.BasicChartDataset;
import jp.sf.orangesignal.chart.data.StepChartDataset;
import jp.sf.orangesignal.chart.data.TimeSeriesChartDataset;
import jp.sf.orangesignal.chart.data.loader.ChartDataLoader;
import jp.sf.orangesignal.chart.data.loader.RuntimeIOException;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartListener;
import jp.sf.orangesignal.chart.event.DataLoadEvent;
import jp.sf.orangesignal.chart.event.DataLoadListener;
import jp.sf.orangesignal.chart.event.SideScreenEvent;
import jp.sf.orangesignal.chart.event.SideScreenListener;
import jp.sf.orangesignal.chart.ui.ChartScreenType;
import jp.sf.orangesignal.chart.ui.DatasetType;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.PeriodType;
import jp.sf.orangesignal.chart.ui.UpDownColorType;
import jp.sf.orangesignal.chart.ui.screen.Analysis;
import jp.sf.orangesignal.chart.ui.screen.AntiWatchScreen;
import jp.sf.orangesignal.chart.ui.screen.AntiWatchSideScreen;
import jp.sf.orangesignal.chart.ui.screen.ChartScreen;
import jp.sf.orangesignal.chart.ui.screen.HistoricalDataScreen;
import jp.sf.orangesignal.chart.ui.screen.HistoricalDataSideScreen;
import jp.sf.orangesignal.chart.ui.screen.KagiSideScreen;
import jp.sf.orangesignal.chart.ui.screen.Option;
import jp.sf.orangesignal.chart.ui.screen.PointFigureSideScreen;
import jp.sf.orangesignal.chart.ui.screen.RenkohSideScreen;
import jp.sf.orangesignal.chart.ui.screen.ShinneSideScreen;
import jp.sf.orangesignal.chart.ui.screen.SideScreen;
import jp.sf.orangesignal.chart.ui.screen.StepChartScreen;
import jp.sf.orangesignal.chart.ui.screen.TimeSeriesScreen;
import jp.sf.orangesignal.chart.ui.screen.TimeSeriesSideScreen;
import jp.sf.orangesignal.chart.unit.BidAndOfferUnits;
import jp.sf.orangesignal.chart.unit.PointFigureUnits;
import jp.sf.orangesignal.chart.util.StringManager;
import jp.sf.orangesignal.ta.TechnicalAnalysis;
import jp.sf.orangesignal.ta.util.Assert;
import jp.sf.orangesignal.ta.util.NumberUtils;
import jp.sf.orangesignal.ta.util.StringUtils;
import netscape.javascript.JSObject;

public class ChartApplet
extends Applet
implements ActionListener,
DataLoadListener,
SideScreenListener {
    private static final long serialVersionUID = 2036788015314585052L;
    protected CardLayout chartScreenLayout = new CardLayout();
    protected Container chartScreen = new Container();
    protected JComboBox screenComboBox;
    protected JComboBox datasetComboBox;
    protected JComboBox periodComboBox;
    protected CardLayout sideScreenLayout = new CardLayout();
    protected Container sideScreen = new Container();
    protected List<ChartListener> listeners = new ArrayList<ChartListener>(14);
    protected BasicChartDataset dataset;
    protected Map<DatasetType, ChartSettings> settings = new EnumMap<DatasetType, ChartSettings>(DatasetType.class);
    private static final String KEY = "chart";
    private static final char SEPARATOR = '|';
    private final Object lock = new Object();
    private ChartDataLoader dataLoader;

    @Override
    public String getAppletInfo() {
        Package pkg = ChartApplet.class.getPackage();
        return StringManager.getString("appletinfo", pkg.getSpecificationTitle(), pkg.getSpecificationVersion());
    }

    @Override
    public void init() {
        this.processLayout();
        this.initSettings();
        this.loadData();
        this.loadSettings();
    }

    @Override
    public void destroy() {
        this.settings.clear();
        this.settings = null;
        this.listeners.clear();
        this.listeners = null;
        this.chartScreen.removeAll();
        this.chartScreen = null;
        this.sideScreen.removeAll();
        this.sideScreen = null;
        this.screenComboBox = null;
        this.datasetComboBox = null;
        this.periodComboBox = null;
        this.dataset = null;
    }

    protected void processLayout() {
        Icons icons = this.loadIcons();
        this.processUIManager(icons);
        this.chartScreen.setLayout(this.chartScreenLayout);
        this.sideScreen.setLayout(this.sideScreenLayout);
        this.sideScreen.setMinimumSize(new Dimension(216, 0));
        this.addScreen(ChartScreenType.TIME_SERIES, new TimeSeriesScreen(icons), new TimeSeriesSideScreen(icons));
        this.addScreen(ChartScreenType.POINT_AND_FIGURE, new StepChartScreen(icons, ChartScreenType.POINT_AND_FIGURE), new PointFigureSideScreen(icons));
        this.addScreen(ChartScreenType.KAGI, new StepChartScreen(icons, ChartScreenType.KAGI), new KagiSideScreen(icons));
        this.addScreen(ChartScreenType.RENKOH, new StepChartScreen(icons, ChartScreenType.RENKOH), new RenkohSideScreen(icons));
        this.addScreen(ChartScreenType.SHINNE, new StepChartScreen(icons, ChartScreenType.SHINNE), new ShinneSideScreen(icons));
        this.addScreen(ChartScreenType.ANTI_WATCH, new AntiWatchScreen(icons), new AntiWatchSideScreen(icons));
        this.addScreen(ChartScreenType.HISTORICAL_DATA, new HistoricalDataScreen(icons), new HistoricalDataSideScreen(icons));
        this.screenComboBox = new JComboBox<ChartScreenType>(new ChartScreenType[]{ChartScreenType.TIME_SERIES, ChartScreenType.POINT_AND_FIGURE, ChartScreenType.KAGI, ChartScreenType.RENKOH, ChartScreenType.SHINNE, ChartScreenType.ANTI_WATCH, ChartScreenType.HISTORICAL_DATA});
        this.screenComboBox.addActionListener(this);
        this.datasetComboBox = new JComboBox<DatasetType>(DatasetType.values());
        this.datasetComboBox.addActionListener(this);
        this.periodComboBox = new JComboBox<PeriodType>(PeriodType.values());
        this.periodComboBox.setMaximumRowCount(9);
        this.periodComboBox.setSelectedItem((Object)PeriodType.SIX_MONTH);
        this.periodComboBox.addActionListener(this);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(layout);
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 3;
        c.weightx = 100.0;
        c.weighty = 100.0;
        layout.setConstraints(this.chartScreen, c);
        this.add(this.chartScreen);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        layout.setConstraints(this.screenComboBox, c);
        this.add(this.screenComboBox);
        c.fill = 2;
        c.gridy = 1;
        c.gridwidth = 1;
        layout.setConstraints(this.datasetComboBox, c);
        this.add(this.datasetComboBox);
        c.gridx = 2;
        layout.setConstraints(this.periodComboBox, c);
        this.add(this.periodComboBox);
        c.fill = 1;
        c.anchor = 11;
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weighty = 100.0;
        layout.setConstraints(this.sideScreen, c);
        this.add(this.sideScreen);
    }

    protected Icons loadIcons() {
        Icons icons = new Icons();
        icons.setOnepoint(this.getImage("/images/onepoint.gif"));
        icons.setSplit(this.getImage("/images/split.gif"));
        return icons;
    }

    public Image getImage(String name) {
        try {
            URL url = this.getClass().getResource(name);
            return this.createImage((ImageProducer)url.getContent());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e.getMessage(), e);
        }
    }

    protected void processUIManager(Icons icons) {
        UIManager.LookAndFeelInfo[] infos;
        for (UIManager.LookAndFeelInfo info : infos = UIManager.getInstalledLookAndFeels()) {
            if (!"com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel".equals(info.getClassName())) continue;
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
                break;
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
        UIManager.put("CheckBox.font", FontConstants.FONT_GUI);
        UIManager.put("ComboBox.font", FontConstants.FONT_GUI);
        UIManager.put("Label.font", FontConstants.FONT_GUI);
        UIManager.put("Panel.background", Color.WHITE);
        UIManager.put("Panel.font", FontConstants.FONT_GUI);
        UIManager.put("ScrollPane.font", FontConstants.FONT_GUI);
        UIManager.put("Spinner.font", FontConstants.FONT_INDEX_SMALL);
        UIManager.put("TabbedPane.background", Color.WHITE);
        UIManager.put("TabbedPane.contentBorderInsets", new Insets(1, 1, 1, 1));
        UIManager.put("TabbedPane.font", FontConstants.FONT_GUI);
        UIManager.put("TabbedPane.textIconGap", 2);
        UIManager.put("TextArea.font", FontConstants.FONT_MESSAGE);
        UIManager.put("ViewPort.font", FontConstants.FONT_GUI);
    }

    protected void addScreen(ChartScreenType screenType, ChartScreen chartScreen, SideScreen sideScreen) {
        Assert.notNull((Object)((Object)screenType), (String)"ChartScreenType must not be null");
        Assert.notNull((Object)chartScreen, (String)"ChartScreen must not be null");
        Assert.notNull((Object)sideScreen, (String)"SideScreen must not be null");
        chartScreen.setScreenType(screenType);
        sideScreen.setScreenType(screenType);
        this.chartScreen.add(screenType.toString(), chartScreen);
        this.sideScreen.add(screenType.toString(), sideScreen);
        this.listeners.add(chartScreen);
        this.listeners.add(sideScreen);
        chartScreen.addChartScreenListener(sideScreen);
        sideScreen.addSideScreenListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj.equals(this.screenComboBox)) {
            this.switchScreen();
        } else if (obj.equals(this.datasetComboBox)) {
            this.switchDataset();
        } else if (obj.equals(this.periodComboBox)) {
            this.switchPeriod();
        }
        this.saveSettings();
    }

    protected void switchScreen() {
        ChartScreenType screenType = (ChartScreenType)((Object)this.screenComboBox.getSelectedItem());
        this.sideScreenLayout.show(this.sideScreen, screenType.toString());
        this.chartScreenLayout.show(this.chartScreen, screenType.toString());
    }

    protected Map<ChartScreenType, ChartEvent> createChartEvents(boolean ignoreStart) {
        EnumMap<ChartScreenType, ChartEvent> results = new EnumMap<ChartScreenType, ChartEvent>(ChartScreenType.class);
        if (this.dataset != null) {
            DatasetType datasetType = (DatasetType)((Object)this.datasetComboBox.getSelectedItem());
            PeriodType periodType = (PeriodType)((Object)this.periodComboBox.getSelectedItem());
            ChartSettings settings = this.settings.get((Object)datasetType);
            BasicChartDataset dataset = this.dataset.createDataset(datasetType, settings.split);
            results.put(ChartScreenType.HISTORICAL_DATA, new ChartEvent(this, dataset, datasetType, periodType, ignoreStart, settings));
            results.put(ChartScreenType.TIME_SERIES, new ChartEvent(this, new TimeSeriesChartDataset(dataset, datasetType, periodType, settings), datasetType, periodType, ignoreStart, settings));
            double avg = dataset.getMaxHighLowAverage();
            double point = new PointFigureUnits().getCeilingUnit((int)avg).getPoint() / 2.0 * (double)settings.pf.point;
            results.put(ChartScreenType.POINT_AND_FIGURE, new ChartEvent(this, new StepChartDataset(TechnicalAnalysis.pf((Date[])dataset.date, (Number[])dataset.techClose, (double)point, (int)settings.pf.reversal), point), datasetType, periodType, ignoreStart, settings));
            results.put(ChartScreenType.KAGI, new ChartEvent(this, new StepChartDataset(TechnicalAnalysis.kagi((Date[])dataset.date, (Number[])dataset.techClose, (double)settings.kagi.rate)), datasetType, periodType, ignoreStart, settings));
            double price = new BidAndOfferUnits().getCeilingUnit((int)avg).getPoint() * (double)settings.renkoh.rate;
            results.put(ChartScreenType.RENKOH, new ChartEvent(this, new StepChartDataset(TechnicalAnalysis.renkoh((Date[])dataset.date, (Number[])dataset.techClose, (double)price), price), datasetType, periodType, ignoreStart, settings));
            results.put(ChartScreenType.SHINNE, new ChartEvent(this, new StepChartDataset(TechnicalAnalysis.shinne((Date[])dataset.date, (Number[])dataset.techClose, (int)settings.shinne.reversal)), datasetType, periodType, ignoreStart, settings));
            if (dataset.volume != null) {
                results.put(ChartScreenType.ANTI_WATCH, new ChartEvent(this, new AntiWatchChartDataset(dataset, settings.antiwatch), datasetType, periodType, ignoreStart, settings));
            }
        }
        return results;
    }

    protected void switchDataset() {
        Map<ChartScreenType, ChartEvent> events = this.createChartEvents(false);
        for (ChartListener listener : this.listeners) {
            ChartEvent event;
            if (listener instanceof ChartScreen) {
                event = events.get((Object)((ChartScreen)listener).getScreenType());
            } else if (listener instanceof SideScreen) {
                event = events.get((Object)((SideScreen)listener).getScreenType());
            } else {
                throw new RuntimeException();
            }
            listener.datasetSwitch(event);
        }
    }

    protected void switchPeriod() {
        Map<ChartScreenType, ChartEvent> events = this.createChartEvents(false);
        for (ChartListener listener : this.listeners) {
            ChartEvent event;
            if (listener instanceof ChartScreen) {
                event = events.get((Object)((ChartScreen)listener).getScreenType());
            } else if (listener instanceof SideScreen) {
                event = events.get((Object)((SideScreen)listener).getScreenType());
            } else {
                throw new RuntimeException();
            }
            listener.periodSwitch(event);
        }
    }

    @Override
    public void optionChanged(SideScreenEvent e) {
        block15: {
            ChartSettings settings;
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block14: {
                                    settings = this.settings.get(this.datasetComboBox.getSelectedItem());
                                    if (!(e.getSource() instanceof Analysis)) break block14;
                                    ((Analysis)e.getSource()).save(settings);
                                    ChartEvent event = this.createChartEvents(true).get((Object)ChartScreenType.TIME_SERIES);
                                    for (ChartListener listener : this.listeners) {
                                        if (!(listener instanceof TimeSeriesScreen) && !(listener instanceof TimeSeriesSideScreen)) continue;
                                        listener.settingChanged(event);
                                    }
                                    break block15;
                                }
                                if (!(e.getSource() instanceof Option)) break block16;
                                Option screen = (Option)e.getSource();
                                boolean flash = false;
                                boolean visible = screen.advancedOptions.isSelected();
                                for (ChartSettings values : this.settings.values()) {
                                    if (!flash) {
                                        flash = visible != values.advancedOptions;
                                    }
                                    screen.save(values);
                                }
                                Map<ChartScreenType, ChartEvent> events = this.createChartEvents(false);
                                for (ChartListener listener : this.listeners) {
                                    ChartEvent event;
                                    if (listener instanceof ChartScreen) {
                                        event = events.get((Object)((ChartScreen)listener).getScreenType());
                                    } else if (listener instanceof SideScreen) {
                                        event = events.get((Object)((SideScreen)listener).getScreenType());
                                        if (flash) {
                                            ((SideScreen)listener).setVisibleAdvancedOptions(visible);
                                        }
                                    } else {
                                        throw new RuntimeException();
                                    }
                                    listener.periodSwitch(event);
                                }
                                this.saveSettings();
                                break block15;
                            }
                            if (!(e.getSource() instanceof PointFigureSideScreen)) break block17;
                            PointFigureSideScreen side = (PointFigureSideScreen)e.getSource();
                            side.save(settings);
                            ChartEvent event = this.createChartEvents(side.isIgnoreStart(settings)).get((Object)ChartScreenType.POINT_AND_FIGURE);
                            for (ChartListener listener : this.listeners) {
                                if (!(listener instanceof PointFigureSideScreen) && (!(listener instanceof StepChartScreen) || ((StepChartScreen)listener).getScreenType() != ChartScreenType.POINT_AND_FIGURE)) continue;
                                listener.settingChanged(event);
                            }
                            break block15;
                        }
                        if (!(e.getSource() instanceof KagiSideScreen)) break block18;
                        KagiSideScreen side = (KagiSideScreen)e.getSource();
                        side.save(settings);
                        ChartEvent event = this.createChartEvents(side.isIgnoreStart(settings)).get((Object)ChartScreenType.KAGI);
                        for (ChartListener listener : this.listeners) {
                            if (!(listener instanceof KagiSideScreen) && (!(listener instanceof StepChartScreen) || ((StepChartScreen)listener).getScreenType() != ChartScreenType.KAGI)) continue;
                            listener.settingChanged(event);
                        }
                        break block15;
                    }
                    if (!(e.getSource() instanceof RenkohSideScreen)) break block19;
                    RenkohSideScreen side = (RenkohSideScreen)e.getSource();
                    side.save(settings);
                    ChartEvent event = this.createChartEvents(side.isIgnoreStart(settings)).get((Object)ChartScreenType.RENKOH);
                    for (ChartListener listener : this.listeners) {
                        if (!(listener instanceof RenkohSideScreen) && (!(listener instanceof StepChartScreen) || ((StepChartScreen)listener).getScreenType() != ChartScreenType.RENKOH)) continue;
                        listener.settingChanged(event);
                    }
                    break block15;
                }
                if (!(e.getSource() instanceof ShinneSideScreen)) break block20;
                ShinneSideScreen side = (ShinneSideScreen)e.getSource();
                side.save(settings);
                ChartEvent event = this.createChartEvents(side.isIgnoreStart(settings)).get((Object)ChartScreenType.SHINNE);
                for (ChartListener listener : this.listeners) {
                    if (!(listener instanceof ShinneSideScreen) && (!(listener instanceof StepChartScreen) || ((StepChartScreen)listener).getScreenType() != ChartScreenType.SHINNE)) continue;
                    listener.settingChanged(event);
                }
                break block15;
            }
            if (!(e.getSource() instanceof AntiWatchSideScreen)) break block15;
            AntiWatchSideScreen side = (AntiWatchSideScreen)e.getSource();
            side.save(settings);
            ChartEvent event = this.createChartEvents(side.isIgnoreStart(settings)).get((Object)ChartScreenType.ANTI_WATCH);
            for (ChartListener listener : this.listeners) {
                if (!(listener instanceof AntiWatchScreen) && !(listener instanceof AntiWatchSideScreen)) continue;
                listener.settingChanged(event);
            }
        }
    }

    private void initSettings() {
        this.settings.clear();
        int precision = NumberUtils.toInt((String)this.getParameter("precision"));
        ChartSettings d = new ChartSettings();
        d.precision = precision;
        this.settings.put(DatasetType.DAILY, d);
        ChartSettings w = new ChartSettings();
        w.precision = precision;
        w.timeSeries.ma1Period = 13;
        w.timeSeries.ma2Period = 26;
        w.timeSeries.donchianPeriod = 4;
        w.timeSeries.biasPeriod = 13;
        w.timeSeries.bbPeriod = 13;
        w.timeSeries.psy_period = 13;
        w.timeSeries.vr1Period = 13;
        w.timeSeries.vr2Period = 13;
        w.timeSeries.vma1Period = 13;
        w.timeSeries.vma2Period = 26;
        w.antiwatch.maPeriod = 13;
        this.settings.put(DatasetType.WEEKLY, w);
        ChartSettings m = new ChartSettings();
        m.precision = precision;
        m.timeSeries.ma1Period = 12;
        m.timeSeries.ma2Period = 24;
        m.timeSeries.donchianPeriod = 1;
        m.timeSeries.biasPeriod = 12;
        m.timeSeries.bbPeriod = 12;
        m.timeSeries.psy_period = 12;
        m.timeSeries.vr1Period = 12;
        m.timeSeries.vr2Period = 12;
        m.timeSeries.vma1Period = 12;
        m.timeSeries.vma2Period = 24;
        m.antiwatch.maPeriod = 12;
        this.settings.put(DatasetType.MONTHLY, m);
    }

    private void loadSettings() {
        String[] s = this.getCookie(KEY).split("\\|");
        if (s == null || s.length <= 1) {
            return;
        }
        boolean split = NumberUtils.toInt((String)s[4]) != 0;
        boolean trace = NumberUtils.toInt((String)s[5]) != 0;
        boolean advancedOptions = NumberUtils.toInt((String)s[8]) == 1;
        for (ChartSettings settings : this.settings.values()) {
            settings.split = split;
            settings.trace = trace;
            settings.updownBarColors = UpDownColorType.values()[NumberUtils.toInt((String)s[6])];
            settings.updownLineColors = UpDownColorType.values()[NumberUtils.toInt((String)s[7])];
            settings.advancedOptions = advancedOptions;
        }
        this.screenComboBox.setSelectedIndex(NumberUtils.toInt((String)s[1]));
        this.datasetComboBox.setSelectedIndex(NumberUtils.toInt((String)s[2]));
        this.periodComboBox.setSelectedIndex(NumberUtils.toInt((String)s[3]));
    }

    private void saveSettings() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append(ChartApplet.class.getPackage().getImplementationVersion());
        sb.append('|').append(this.screenComboBox.getSelectedIndex());
        sb.append('|').append(this.datasetComboBox.getSelectedIndex());
        sb.append('|').append(this.periodComboBox.getSelectedIndex());
        ChartSettings s = this.settings.get((Object)DatasetType.DAILY);
        sb.append('|').append(s.split ? 1 : 0);
        sb.append('|').append(s.trace ? 1 : 0);
        sb.append('|');
        sb.append(s.updownBarColors.ordinal());
        sb.append('|');
        sb.append(s.updownLineColors.ordinal());
        sb.append('|');
        sb.append(s.advancedOptions ? 1 : 0);
        Calendar c = Calendar.getInstance();
        c.add(2, 1);
        this.setCookie(KEY, sb.toString(), c.getTime());
    }

    private void setCookie(String key, Object value, Date expires) {
        StringBuilder line = new StringBuilder(1024);
        line.append(key).append('=');
        if (value != null) {
            line.append(value.toString());
        }
        if (expires != null) {
            line.append("; expires=").append(expires.toString());
        }
        try {
            JSObject document = (JSObject)JSObject.getWindow((Applet)this).getMember("document");
            document.setMember("cookie", line.toString());
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    private String getCookie(String key) {
        String search = key + '=';
        String cookie = this.getCookie() + ';';
        int start = cookie.indexOf(search);
        if (start != -1) {
            return cookie.substring(start + search.length(), cookie.indexOf(59, start));
        }
        return "";
    }

    private String getCookie() {
        try {
            JSObject document = (JSObject)JSObject.getWindow((Applet)this).getMember("document");
            return StringUtils.defaultString((String)((String)document.getMember("cookie")));
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadData() {
        Object object = this.lock;
        synchronized (object) {
            ServiceLoader<ChartDataLoader> loader = ServiceLoader.load(ChartDataLoader.class);
            Iterator<ChartDataLoader> i$ = loader.iterator();
            if (i$.hasNext()) {
                ChartDataLoader service;
                this.dataLoader = service = i$.next();
                this.dataLoader.addDataLoadListener(this);
                this.dataLoader.load(this);
            }
            Assert.state((this.dataLoader == null ? 1 : 0) != 0, (String)"ChartDataLoader not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataLoaded(DataLoadEvent e) {
        this.dataset = e.getDataset();
        this.switchDataset();
        Object object = this.lock;
        synchronized (object) {
            this.dataLoader = null;
        }
    }
}

