/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.result;

import java.io.Serializable;
import java.util.Date;

public class Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Date openDate;
    public Date highDate;
    public Date lowDate;
    public Date closeDate;
    public double open;
    public double high;
    public double low;
    public double close;
    public int period;

    protected Step() {
    }

    public Step(Date date, double price) {
        this(date, price, 1);
    }

    public Step(Date date, double price, int period) {
        this.openDate = date;
        this.highDate = date;
        this.lowDate = date;
        this.closeDate = date;
        this.open = price;
        this.high = price;
        this.low = price;
        this.close = price;
        this.period = period;
    }

    public static int indexOf(Step[] array, Date find) {
        return Step.indexOf(array, find, 0);
    }

    public static int indexOf(Step[] array, Date find, int start) {
        int _start;
        if (array == null) {
            return -1;
        }
        int length = array.length;
        for (int i = _start = start >= 0 ? start : 0; i < length; ++i) {
            if (array[i] == null || array[i].openDate.compareTo(find) > 0 || array[i].closeDate.compareTo(find) < 0) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(Step[] array, Date find) {
        return Step.lastIndexOf(array, find, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Step[] array, Date find, int start) {
        int _start;
        if (array == null) {
            return -1;
        }
        for (int i = _start = start >= (length = array.length) ? length - 1 : start; i >= 0; --i) {
            if (array[i] == null || array[i].openDate.compareTo(find) > 0 || array[i].closeDate.compareTo(find) < 0) continue;
            return i;
        }
        return -1;
    }
}

