/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/WM/GMQ.cpp
	概要		：	グローバル・メッセージ・キュー・クラス
	詳細		：	メッセージをウィンドウ管理に渡すためのキューバッファです。
					すべてのメッセージは、必ずこのキューバッファを通ります。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"Common.h"
#include	"GMQ.h"
#include	"TM/TM.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	グローバル
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
extern TM		G_TM;			//タスク管理
extern Task*	GP_WMTask;		//ウィンドウ管理タスク



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	GMQクラス：パブリックメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	デバイス・データ・エンキュー
	説明	：	キューにデバイス・データを格納し、書き込みポインタをインクリメントします。
	Include	：	GMQ.h
	引数	：	const Msg& CR_Message		格納するデータ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		GMQ::Enqueue( const Msg& CR_Message )
{
	//書き込みポインタの次に読み込みポインタがあれば、書き込み拒否
	if( Mu1_Read == Mu1_Write + 1 )
		return ERROR_QUEUE_FULL;

	MA_GMQ[Mu1_Write++] = CR_Message;

	//ウィンドウ管理タスクを起動
	G_TM.WakeupTask( GP_WMTask );
	return SUCCESS;
}

/*******************************************************************************
	概要	：	デキュー
	説明	：	キューからデータを取得し、読み込みポインタをインクリメントします。
	Include	：	GMQ.h
	引数	：	Msg* P_Message		取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		GMQ::Dequeue( Msg* P_Message )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*P_Message = MA_GMQ[Mu1_Read++];
	return SUCCESS;
}

/*******************************************************************************
	概要	：	データ読み取り
	説明	：	キューからデータを取得します。
				参照するだけで、ポインタのインクリメントは行いません。
	Include	：	GMQ.h
	引数	：	Msg* P_Message		取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		GMQ::Read( Msg* P_Message )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*P_Message = MA_GMQ[Mu1_Read];
	return SUCCESS;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
