/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/RDTM/RDTM.cpp
	概要		：	実時間管理(Real date time management)
	詳細		：	現在の時刻を管理します。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"Common.h"
#include	"RDTM.h"
#include	"RTC.h"
#include	"TM.h"

//デバッグ用
#include	<stdio.h>
#include	"GUI/GUI.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	グローバル
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
extern RDTM		G_RDTM;
extern RTC		G_RTC;
extern TM		G_TM;


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	実時間管理クラス：パブリックメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	実時間管理クラスの初期化
	説明	：
	Include	：	RDTM.h
	引数	：	void
	戻り値	：	void
*******************************************************************************/
void	RDTM::Init( void )
{
	Mu8_MSecCount = 0;
	G_RTC.GetDateTime( &M_RealDateTime );		//RTCから現在時刻取得

	DP( "RDTM::Init()\t\t\t\t\t\t\t\t[  OK  ]" );
}


/*******************************************************************************
	概要	：	現在の時刻を取得
	説明	：
	Include	：	RDTM.h
	引数	：	void
	戻り値	：	DateTime	現在の日時
*******************************************************************************/
void	RDTM::GetRealDateTime( DateTime* P_DateTime )
{
	*P_DateTime = M_RealDateTime;
}


/*******************************************************************************
	概要	：	時刻を進める(割り込み)
	説明	：	PITに呼ばれ、時間を進めます。
				秒を進めて、時刻タスクを起動し、後は時刻タスクに任せます。
	Include	：	RDTM.h
	引数	：	void
	戻り値	：	void
*******************************************************************************/
void	RDTM::SetForward( void )
{
	Mu8_MSecCount++;
	M_RealDateTime.SetForwardMSec();
}


/*******************************************************************************
	概要	：	タイマーウェイト
	説明	：	ミリ秒単位の時間待機します。
				マルチタスクに関係なく正確な時間で待機しますが、細かい単位は正確ではありません。
	Include	：	RDTM.h
	引数	：	ui ui_MSec		待機する時間(ミリ秒)
	戻り値	：	void
*******************************************************************************/
void	RDTM::WaitMSec( ui ui_MSec )
{
	u8		u8_StartMSec = Mu8_MSecCount;

	while( Mu8_MSecCount - u8_StartMSec < ui_MSec )
	{
		G_TM.TaskSwitch();
	}
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

