/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/MM/GMA.h
	概要		：	全域メモリ割り当てヘッダ
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"MM.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	メモリマップ構造体
*******************************************************************************/
struct	MemoryMap
{
public:
	u8		u8_Base;
	u8		u8_Size;
	u8		u8_Type;
};


/*******************************************************************************
	GMAクラス
*******************************************************************************/
class	GMA : public MA
{
//メソッド
public:
	void	Init( void );				//初期化

	ui		Create( ui ui_ByteSize );	//メモリ領域作成

private:
	//Init用
	u4		BaseAlign( u4 u4_Base );				//ベースを4KiB境界に揃える
	u4		SizeAlign( u4 u4_Base, u4 u4_Size );	//サイズを4KiB境界に揃える
};



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
