/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/DTM/Descriptor.h
	概要		：	ディスクリプタ
	詳細		：	ディスクリプタを直接表す構造体や、
					ディスクリプタの情報をわかりやすく定義しました。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	クラス・構造体定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	セグメント・ディスクリプタ
	ディスクリプタ・テーブル用8バイト構造体
*******************************************************************************/
struct	SegmDesc
{
public:
	u2		u2_LimitLow;
	u2		u2_BaseLow;
	u4		u1_BaseMid		: 8;
	u4		u5b_Type		: 5;
	u4		u2b_DPL			: 2;
	u4		u1b_Present		: 1;
	u4		u4b_LimitHigh	: 4;
	u4		u1b_Available	: 1;
	u4						: 1;
	u4		u1b_DefaultSize	: 1;
	u4		u1b_Granularity	: 1;
	u4		u1_BaseHigh		: 8;
};


/*******************************************************************************
	ゲート・ディスクリプタ
	ディスクリプタ・テーブル用8バイト構造体
*******************************************************************************/
struct	GateDesc
{
public:
	u2		u2_OffsetLow;
	u2		u2_Selector;
	u4		u1_ParamCount	: 8;
	u4		u5b_Type		: 5;
	u4		u2b_DPL			: 2;
	u4		u1b_Present		: 1;
	u4		u2_OffsetHigh	: 16;
};

//■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■

/*******************************************************************************
	セグメント情報
*******************************************************************************/
struct	SegmInfo
{
public:
	u4		u4_Base;			//ベースアドレス
	u4		u20b_Limit		: 20;	//セグメント・リミット
	u4						: 0;
	u4		u5b_Type		: 5;	//ディスクリプタ・タイプ
	u4		u2b_DPL			: 2;	//ディスクリプタ特権レベル
	u4		u1b_Present		: 1;	//存在(true)/不在(false)フラグ
	u4		u1b_Available	: 1;	//自由利用フラグ(不使用)
	u4		u1b_DefaultSize	: 1;	//32bit(true)/16bit(false)フラグ
	u4		u1b_Granularity	: 1;	//ページ単位(true)/バイト単位(false)フラグ
};


/*******************************************************************************
	ゲート情報
*******************************************************************************/
struct	GateInfo
{
public:
	u4		u4_Offset;			//オフセット
	u4		SegmSelector	: 16;	//セグメント・セレクタ
	u4		u1_ParamCount	: 8;	//パラメータカウント
	u4		u5b_Type		: 5;	//ディスクリプタ・タイプ
	u4		u2b_DPL			: 2;	//ディスクリプタ特権レベル
	u4		u1b_Present		: 1;	//存在(true)/不在(false)フラグ
};



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
