/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Kernel/DM/GDDQ.cpp
	概要		：	デバイス・データ・キュー クラス
	詳細		：	デバイスデータをOSに渡すためのキューバッファです。
					すべてのデバイスデータは、必ずこのキューバッファを通ります。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"Common.h"
#include	"GDDQ.h"
#include	"TM/TM.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	グローバル
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
extern TM		G_TM;			//タスク管理
extern Task*	GP_GDDMTask;	//グローバル・デバイス・データ管理

extern bool	Gb_InitFinishFlag;



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	GDDQクラス：パブリックメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	デバイス・データ・エンキュー
	説明	：	キューにデバイス・データを格納し、書き込みポインタをインクリメントします。
	Include	：	GDDQ.h
	引数	：	const DD& CR_DeviceData	格納するデータ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		GDDQ::Enqueue( const DD& CR_DeviceData )
{
	if( !Gb_InitFinishFlag )
		return -1;
	//書き込みポインタの次に読み込みポインタがあれば、書き込み拒否
	if( Mu1_Read == Mu1_Write + 1 )
		return ERROR_QUEUE_FULL;

	MA_GDDQ[Mu1_Write++] = CR_DeviceData;

	//ウィンドウ管理タスクを起動
	G_TM.WakeupTask( GP_GDDMTask );
	return SUCCESS;
}

/*******************************************************************************
	概要	：	デキュー
	説明	：	キューからデータを取得し、読み込みポインタをインクリメントします。
	Include	：	GDDQ.h
	引数	：	DD* P_DeviceData	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		GDDQ::Dequeue( DD* P_DeviceData )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*P_DeviceData = MA_GDDQ[Mu1_Read++];
	return SUCCESS;
}

/*******************************************************************************
	概要	：	データ読み取り
	説明	：	キューからデータを取得します。
				参照するだけで、ポインタのインクリメントは行いません。
	Include	：	GDDQ.h
	引数	：	DD* P_DeviceData	取得するデータを格納するポインタ
	戻り値	：	s4		エラー情報
*******************************************************************************/
s4		GDDQ::Read( DD* P_DeviceData )
{
	//読み込みポインタが書き込みポインタと同じ位置ならエラー。
	if( Mu1_Read == Mu1_Write )
		return ERROR_QUEUE_NULL;

	*P_DeviceData = MA_GDDQ[Mu1_Read];
	return SUCCESS;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
