/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Mul_light/Boot/BootLoader/Graphics.S
	概要		：	グラフィックスの設定
	説明		：	VBEによるグラフィックスの設定を行います。
					もし、ビデオカードがVBE2.0に対応指定ない場合は、VGAでしょぼいモードを利用します。。
					グラフィックス情報は0x0000 0500〜0x0000 05ffに格納します。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"Common.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	グローバル定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
	.global		_SetGraphics



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	定数定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#VESA情報バッファアドレス
_ES_			= PARAM_BASE >> 4
_DI_			= 0x0000

#グラフィックス情報の格納アドレス
X_RES_ADDR		= 0x0012			#解像度X
Y_RES_ADDR		= 0x0014			#解像度Y
BPD_ADDR		= 0x0019			#Bit/Dot。色数に関する情報。何ビットカラーか
VRAM_ADDR		= 0x0028			#VRAMの開始アドレス

#VBEのモード
VBE_MODE		= 0x0118			#1024x768, 24/32bitカラー

#VGAのモード
VGA_MODE		= 0x0013			#320x200, 8bitカラー
VGA_X_RES		= 320				#解像度X
VGA_Y_RES		= 200				#解像度Y
VGA_BPD			= 8					#Bit/Dot。色数に関する情報。何ビットカラーか
VGA_VRAM		= 0x000a0000		#VRAMの開始アドレス



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	プログラム
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
	.section .text
	.code16

/*******************************************************************************
	グラフィックスの設定
*******************************************************************************/
_SetGraphics:
/*------------------------------------------------------------------------------
	VESAインフォメーション取得

	パラメータ
	ah:VESAファンクション(0x4f)
	al:VESAの情報を取得するコマンド(0x00)
	es:di:VESA情報を受け取るバッファアドレス(256Byte以上)

	戻り値
	ah:
		0x00	正常に終了した
		0x01	失敗した
		0x02	現在のハードウェアでは実行できない
		0x03	現在のモードでは実行できない
	al:
		0x4f	ファンクションが有る
		!0x4f	ファンクションが無い
------------------------------------------------------------------------------*/
	movw		$_ES_,			%ax		#バッファアドレス
	movw		%ax,			%es		#バッファアドレス
	movw		$_DI_,			%di		#バッファアドレス
	movw		$0x4f00,		%ax		#ah:VESAファンクション, al:VESAの情報を取得するコマンド。
	int			$0x10					#VESAの情報取得を実行！

	cmpw		$0x004f,		%ax		#ah = 0（正常終了）, al = 4f（サポート対象）
	jnz			_VGA_Mode				#異常終了ならVGAモードを利用。


	#バージョンチェック
	movw		%es:0x04(%di),	%ax		#取得したVESAのバージョン情報が入ってる。
	cmpw		$0x0200,		%ax		#バージョンが2.0以下ならVBEの利用は我慢する。
	jb			_VGA_Mode				#バージョンが2.0以下ならVGAモードを利用。


/*------------------------------------------------------------------------------
	VBE 指定した画面モードの情報を取得

	パラメータ
	ah:VESAファンクション(0x4f)
	al:指定した画面モードの情報を取得するコマンド(0x01)
	cx:情報を得る画面モード番号(定数:VBE_MODE)
	es:di:VESA情報を受け取るバッファアドレス(256Byte以上)

	戻り値
	ah:
		0x00	正常に終了した
		!0x00	エラー
	al:
		0x4f	サポート
		!0x4f	サポート外
------------------------------------------------------------------------------*/
	movw		$0x4f01,		%ax		#ah:VESAファンクション, al:指定した画面モードの情報を取得するコマンド
	movw		$VBE_MODE,		%cx		#使いたい画面モード
	int			$0x10					#画面モードの情報取得を実行！

	cmpw		$0x004f,		%ax		#ah = 0（正常終了）, al = 4f（サポート対象）
	jnz			_VGA_Mode				#異常終了ならVGAモードを利用。



/*------------------------------------------------------------------------------
	VBE 画面モード設定

	パラメータ
	ah:VESAファンクション(0x4f)
	al:画面モード設定コマンド(0x02)
	bx:
		bit0-13:設定する画面モード番号(定数:VBE_MODE)
		bit14:1_リニアアクセスモード(VESA 2.0以降)
		bit15:1_VRAMクリア省略

	戻り値
	ah:
		0x00	正常に終了した
		!0x00	エラー
	al:
		0x4f	ファンクションが有る
		!0x4f	ファンクションが無い
------------------------------------------------------------------------------*/
VBE_Mode:
	movw		$0x4f02,		%ax		#ah:VESAファンクション, al:画面モードの設定をするコマンド
	movw		$VBE_MODE,		%bx		#設定する画面モード
	orw			$0x4000,		%bx		#14,15bitを1にセット
	int			$0x10					#VBEの関数を実行

	cmpw		$0x004f,		%ax		#ah = 0（正常終了）, al = 4f（サポート対象）
	jnz			_VGA_Mode				#異常終了ならVGAモードを利用。

	#VBEの設定が正常に完了！よかった。
	ret


/*------------------------------------------------------------------------------
	VBEが使えない場合の処理
	通常のVGAを使って、できる限りのことをします。
------------------------------------------------------------------------------*/
_VGA_Mode:
	#VESA情報バッファアドレスを0初期化
	movw		$_ES_,			%ax		#バッファアドレス
	movw		%ax,			%es		#バッファアドレス
	movw		$_DI_,			%di		#バッファアドレス
	xorl		%eax,			%eax	#メモリにストアするデータを初期化
	movw		$0x0080,		%cx		#転送回数。0x0100 / 2
	rep			stosw					#一回の転送で2Byte

	#VGA設定
	movw		$VGA_MODE,		%ax		#設定する画面モード
	int			$0x10

	#VGA設定のデータをメモリに置いておく。
	movw		$VGA_X_RES,		%es:( X_RES_ADDR )		#解像度X
	movw		$VGA_Y_RES,		%es:( Y_RES_ADDR )		#解像度Y
	movb		$VGA_BPD,		%es:( BPD_ADDR )		#Bit/Dot。何ビットカラーか。
	movl		$VGA_VRAM,		%es:( VRAM_ADDR )		#VRAMの開始アドレス

	#残念ながら、VGAに設定して終了。。
	ret



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

