/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/Objects/Content.cpp
	概要		：	Mul light API - コンテントクラス
	詳細		：	何らかの内容を持つオブジェクトです。
					ボックスと違い、子オブジェクトは持ちません。
					抽象的なクラスで、これ自体にあまり意味はありません。
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	インクルード
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
#include	"MLCommon.h"
#include	"Content.h"

#include	"Text.h"



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	コンテントクラス：プロテクティッドメソッド
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	コンテントクラスの初期化
	説明	：
	Include	：	Content.h
	引数	：	void
	戻り値	：	void
*******************************************************************************/
void	Content::Init( void )
{
	Object::Init();
	Object::SetObjectType( Object::CONTENT );

//	Mui_Width		= 0;
//	Mui_Height		= 0;
}


/*******************************************************************************
	概要	：	幅、高さ取得
	説明	：
	Include	：	Content.h
	引数	：	void
	戻り値	：	ui		幅、高さ
*******************************************************************************/
ui		Content::GetWidth( void )
{
	if( CheckInheritance( TEXT ) )
		return ( (Text*)this )->Text::GetWidth();
	return 0;
}
ui		Content::GetHeight( void )
{
	if( CheckInheritance( TEXT ) )
		return ( (Text*)this )->Text::GetHeight();
	return 0;
}



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
