/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	ファイル名	：	/Include/Mul_light/Math.h
	概要		：	Mul light API - 数学関数ヘッダ
	詳細		：
	責任者		：	佐合 秀昭
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/

#pragma	once


/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	マクロ定義
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
/*******************************************************************************
	概要	：	2進数整数の一捨零入
	説明	：	指定のビットで零捨一入を行うマクロです。
	Include	：	Math.h
	引数	：	_VALUE_			演算対象
				_DIGIT_MASK_	零捨一入対象桁のマスク(零捨一入対象桁以下が1)
	戻り値	：	演算結果
*******************************************************************************/
#define	INT_ROUND_BIN( _VALUE_, _DIGIT_MASK_ )		( ( ( _VALUE_ ) & ( _DIGIT_MASK_ ) ) << 1 & ~( _DIGIT_MASK_ ) )


/*******************************************************************************
	概要	：	2進数整数の切り上げ
	説明	：	指定の桁で切り上げを行うマクロです。
	Include	：	Math.h
	引数	：	_VALUE_			演算対象
				_DIGIT_MASK_	切り上げ対象桁のマスク(切り上げ対象桁以下が1)
	戻り値	：	演算結果
*******************************************************************************/
#define	INT_CEIL_BIN( _VALUE_, _DIGIT_MASK_ )		( ( ( _VALUE_ ) + ( _DIGIT_MASK_ ) ) & ~( _DIGIT_MASK_ ) )


/*******************************************************************************
	概要	：	2進数整数の切り捨て
	説明	：	指定の桁で切り捨てを行うマクロです。
	Include	：	Math.h
	引数	：	_VALUE_			演算対象
				_DIGIT_MASK_	切り捨て対象桁のマスク(切り捨て対象桁以下が1)
	戻り値	：	演算結果
*******************************************************************************/
#define	INT_FLOOR_BIN( _VALUE_, _DIGIT_MASK_ )		( ( _VALUE_ ) & ~( _DIGIT_MASK_ ) )



/*******************************************************************************
	概要	：	単位変換
	説明	：	ビット、バイト、ページの単位を変換します。
				下位の単位(ページ > バイト > ビット)への変換で端数は切り捨てられます。
				XXX_CEILは切り上げられます。
	Include	：	Math.h
	引数	：	_BIT_ / _BYTE_ / _PAGE_			演算対象
	戻り値	：	変換結果
*******************************************************************************/
#define	BIT2BYTE( _BIT_ )			( ( _BIT_ ) >> 3 )					//ビット -> バイト
#define	BIT2BYTE_CEIL( _BIT_ )		( ( ( _BIT_ ) + 0x7 ) >> 3 )		//ビット -> バイト(切り上げ)
#define	BIT2PAGE( _BIT_ )			( ( _BIT_ ) >> 15 )					//ビット -> ページ(4KiB)
#define	BIT2PAGE_CEIL( _BIT_ )		( ( ( _BIT_ ) + 0x7fff ) >> 15 )	//ビット -> ページ(4KiB)(切り上げ)

#define	BYTE2BIT( _BYTE_ )			( ( _BYTE_ ) << 3 )					//バイト -> ビット
#define	BYTE2PAGE( _BYTE_ )			( ( _BYTE_ ) >> 12 )				//バイト -> ページ(4KiB)
#define	BYTE2PAGE_CEIL( _BYTE_ )	( ( ( _BYTE_ ) + 0xfff ) >> 12 )	//バイト -> ページ(4KiB)(切り上げ)

#define	PAGE2BIT( _PAGE_ )			( ( _PAGE_ ) << 15 )				//ページ(4KiB) -> ビット
#define	PAGE2BYTE( _PAGE_ )			( ( _PAGE_ ) << 12 )				//ページ(4KiB) -> バイト



/*■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
	End of file
■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■*/
