package jp.sf.nikonikofw.validation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 正規表現チェック用のアノテーションです。
 * 
 * @author Naoki Takezoe
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Pattern {
	
	/**
	 * 許容するパターンを正規表現で指定します。
	 */
	String pattern();
	
	/**
	 * エラーメッセージ。
	 */
	String message() default "%sは%s形式で入力してください。";

}
