package jp.sf.nikonikofw.validation;

import java.lang.reflect.Field;

/**
 * バリデータのインターフェースです。
 * 
 * @author Naoki Takezoe
 */
public interface IValidator {
	
	/**
	 * 値のバリデーションを行います。
	 * 
	 * @param label 項目名
	 * @param field フィールド
	 * @param value 値
	 */
	public void validateValue(String label, Field field, String value);
	
	/**
	 * 配列のバリデーションを行います。
	 * 
	 * @param label 項目名
	 * @param field フィールド
	 * @param values 配列
	 */
	public void validateValues(String label, Field field, String[] values);
	
}
