package jp.sf.nikonikofw.validation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * バイト長チェック用のアノテーションです。
 * 
 * @author Naoki Takezoe
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ByteMinLength {
	
	int length() default 0;
	
	String encoding() default "UTF-8";
	
	String message() default "%sは%dバイト以上で入力してください。";

}
