package jp.sf.nikonikofw.validation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 配列長チェック用のアノテーションです。
 * 
 * @author Naoki Takezoe
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ArrayMaxLength {
	
	int length() default 0;
	
	String message() default "%sは%d項目以内で選択してください。";
	
}
