package jp.sf.nikonikofw.persistence.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

import jp.sf.nikonikofw.exception.InitializeException;
import jp.sf.nikonikofw.exception.PersistenceException;
import jp.sf.nikonikofw.persistence.IPersistenceManager;
import jp.sf.nikonikofw.util.StringUtils;

/**
 * 
 * 
 * @author Naoki Takezoe
 */
public class JdbcPersistenceManager implements IPersistenceManager {
	
	private static Logger logger = Logger.getLogger(JdbcPersistenceManager.class.getName());
	
	private static ThreadLocal<Connection> threadLocal = new ThreadLocal<Connection>();
	
	private static final String CONFIG_PROP_DRIVER = "persistence.jdbc.driver";
	private static final String CONFIG_PROP_URL = "persistence.jdbc.url";
	private static final String CONFIG_PROP_USER = "persistence.jdbc.user";
	private static final String CONFIG_PROP_PASSWORD = "persistence.jdbc.password";
	private static final String CONFIG_PROP_NAMING = "persistence.jdbc.naming";
	
	private String driver;
	private String url;
	private String user;
	private String password;
	
	private INaming naming = new DefaultNaming();
	
	public INaming getNaming(){
		return naming;
	}
	
	public Connection getConnection(){
		return threadLocal.get();
	}

	@Override
	public void begin() {
		try {
			Class.forName(driver);
			
			Connection conn = DriverManager.getConnection(url, user, password);
			conn.setAutoCommit(false);
			
			threadLocal.set(conn);
			
			logger.info("トランザクションを開始しました。");
			
		} catch(ClassNotFoundException ex){
			throw new PersistenceException(ex);
			
		} catch(SQLException ex){
			throw new PersistenceException(ex);
		}
	}

	@Override
	public void close() {
		try {
			getConnection().close();
			logger.info("コネクションをクローズしました。");
		} catch(Exception ex){
			// throw new RuntimeException(ex);
		} finally {
			threadLocal.remove();
		}
	}

	@Override
	public void commit() {
		try {
			getConnection().commit();
			logger.info("トランザクションをコミットしました。");
		} catch(Exception ex){
			throw new RuntimeException(ex);
		}
	}

	@Override
	public void init(Properties props) throws InitializeException {
		this.driver = props.getProperty(CONFIG_PROP_DRIVER);
		this.url = props.getProperty(CONFIG_PROP_URL);
		this.user = props.getProperty(CONFIG_PROP_USER);
		this.password = props.getProperty(CONFIG_PROP_PASSWORD);
		
		String namingClass = props.getProperty(CONFIG_PROP_NAMING);
		if(StringUtils.isNotBlank(namingClass)){
			try {
				Class<?> clazz = Class.forName(namingClass.trim());
				naming = (INaming) clazz.newInstance();
			} catch(Exception ex){
				throw new InitializeException(ex);
			}
		}
	}

	@Override
	public void rollback() {
		try {
			getConnection().rollback();
			logger.info("トランザクションをロールバックしました。");
		} catch(Exception ex){
			throw new RuntimeException(ex);
		}
	}
	
}
