package jp.sf.nikonikofw.persistence.jdbc;


/**
 * {@link INaming}のデフォルト実装です。
 * 
 * @author Naoki Takezoe
 */
public class DefaultNaming implements INaming {

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toDatabaseName(String javaName) {
		StringBuilder sb = new StringBuilder();
		boolean flag = false;
		
		for(int i=0;i<javaName.length();i++){
			char c = javaName.charAt(i);
			
			if(flag == true && (c <'a' || c > 'z')){
				sb.append("_");
				flag = false;
			}
			
			sb.append(String.valueOf(c).toUpperCase());
			
			if(c >= 'a' && c <= 'z'){
				flag = true;
			}
		}
		return sb.toString();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toJavaName(String databaseName) {
		StringBuilder sb = new StringBuilder();
		boolean flag = false;
		for(int i=0;i<databaseName.length();i++){
			char c = databaseName.charAt(i);
			
			if(c == '_'){
				flag = true;
				continue;
			}
			
			if(flag == true){
				sb.append(String.valueOf(c).toUpperCase());
				flag = false;
			} else {
				sb.append(String.valueOf(c).toLowerCase());
				flag = false;
			}
		}
		return sb.toString();
	}

}
