package jp.sf.nikonikofw.authentication;

import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;

/**
 * Google App Engine用の認証マネージャ。
 * 
 * @author Naoki Takezoe
 */
public class GoogleAppEngineAuthenticationManager implements
		IAuthenticationMananger {
	
	private UserService userService = UserServiceFactory.getUserService();
	
	/**
	 * <code>com.google.appengine.api.users.User</code>オブジェクトを返却します。
	 * ログインしていない場合は<code>null</code>を返します。
	 */
	@Override
	public Object getUserInfo() {
		return userService.getCurrentUser();
	}

	@Override
	public boolean isLogin() {
		return userService.isUserLoggedIn();
	}

	@Override
	public boolean isAdmin() {
		return userService.isUserLoggedIn() && userService.isUserAdmin();
	}
	
	/**
	 * このメソッドでは何も行いません。
	 */
	@Override
	public void login(Object obj) {
		// なにもしない
	}

	/**
	 * このメソッドでは何も行いません。
	 */
	@Override
	public void logout() {
		// なにもしない
	}

}
