package jp.sf.nikonikofw;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * <code>HttpServletRequest</code>、<code>HttpServletResponse</code>にアクセスするためのユーティリティです。
 * 
 * @author Naoki Takezoe
 */
public class ServletUtil {
	
	private static ThreadLocal<HttpServletRequest> request = new ThreadLocal<HttpServletRequest>();
	private static ThreadLocal<HttpServletResponse> response = new ThreadLocal<HttpServletResponse>();
	
	/**
	 * リクエストの先頭でフレームワークによって呼び出されます。
	 * 
	 * @param request
	 * @param response
	 */
	static void init(HttpServletRequest request, HttpServletResponse response){
		ServletUtil.request.set(request);
		ServletUtil.response.set(response);
	}
	
	/**
	 * リクエストの終了時にフレームワークによって呼び出されます。
	 * <p>
	 * <code>ThreadLocal</code>に保持したリクエストとレスポンスを削除します。
	 * 
	 */
	static void release(){
		ServletUtil.request.remove();
		ServletUtil.response.remove();
	}
	
	/**
	 * <code>HttpServletRequest</code>を取得します。
	 * 
	 * @return 現在のスレッドのリクエストオブジェクト
	 */
	public static HttpServletRequest getRequest(){
		return ServletUtil.request.get();
	}
	
	/**
	 * <code>HttpSession</code>を取得します。
	 * 
	 * @return 現在のスレッドのセッションオブジェクト
	 */
	public static HttpSession getSession(){
		return ServletUtil.request.get().getSession();
	}
	
	/**
	 * <code>HttpServletResponse</code>を取得します。
	 * 
	 * @return 現在のスレッドのレスポンスオブジェクト
	 */
	public static HttpServletResponse getResponse(){
		return ServletUtil.response.get();
	}
	
}
