package net.sf.amateras.nikocale.action.admin;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.Config;
import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.persistence.jdbc.JdbcPersistenceManager;
import jp.sf.nikonikofw.util.Functions;

import org.apache.commons.lang.StringUtils;

public class ConsoleAction implements IAction {
	
	@Request
	public String execute;
	
	@Request
	public String sql;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		if(StringUtils.isNotEmpty(execute) && StringUtils.isNotEmpty(sql)){
			request.setAttribute("sql", sql);
			
			sql = sql.trim();
			
			JdbcPersistenceManager pm = (JdbcPersistenceManager) Config.getPersistenceManager();
			Connection conn = pm.getConnection();
			
			Statement stmt = null;
			ResultSet rs = null;
			
			StringBuilder result = new StringBuilder();
			
			try {
				stmt = conn.createStatement();
				
				if(sql.toLowerCase().startsWith("select")){
					rs = stmt.executeQuery(sql);
					ResultSetMetaData meta = rs.getMetaData();
					int count = meta.getColumnCount();
					result.append("<table border=\"1\">");
					result.append("<tr>");
					for(int i=1; i <= count; i++){
						result.append("<th>");
						result.append(Functions.h(meta.getColumnName(i)));
						result.append("</th>");
					}
					result.append("</tr>");
					
					while(rs.next()){
						result.append("<tr>");
						for(int i=1; i <= count; i++){
							result.append("<td>");
							if(rs.getString(i) == null){
								result.append("&lt;NULL&gt;");
							} else {
								result.append(Functions.h(rs.getString(i)));
							}
							result.append("</td>");
						}
						result.append("</tr>");
					}
					
					result.append("</table>");
					
				} else {
					int rows = stmt.executeUpdate(sql);
					result.append(rows).append("件更新しました。");
				}
			} catch(Exception ex){
				ex.printStackTrace();
				result.append(Functions.h(ex.toString()));
				
			} finally {
				if(rs != null){
					rs.close();
				}
				if(stmt != null){
					stmt.close();
				}
			}
			
			request.setAttribute("result", result.toString());
		}
		
		request.setAttribute("title", "SQLコンソール");
		
		return "console.jsp";
	}

}
