package net.sf.amateras.nikocale.action;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.action.AbstractNikocaleAction.DateDto;
import net.sf.amateras.nikocale.annotation.Ajax;
import net.sf.amateras.nikocale.entity.GroupCalendar;
import net.sf.amateras.nikocale.service.GroupCalendarService;
import net.sf.amateras.nikocale.service.GroupService;

@Ajax
public class SavecalAction implements IAction {

	@Request
	@Required
	public Long groupId;
	
	@Request
	@Required
	public Integer year;
	
	@Request
	@Required
	public Integer month;
	
	@Request
	@Required
	public Integer day;
	
	@Request
	public String description;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		GroupCalendar calendar = GroupCalendarService.getGroupCalendar(groupId, year, month, day);
		
		Map<Integer, GroupCalendar> data = new HashMap<Integer, GroupCalendar>();
		request.setAttribute("calendar", data);
		request.setAttribute("group", GroupService.getGroup(groupId));
		
		if(calendar == null){
			calendar = new GroupCalendar();
			calendar.groupId = groupId;
			calendar.year = year;
			calendar.month = month;
			calendar.day = day;
			calendar.description = description;
			
			GroupCalendarService.saveCalendar(calendar);
			data.put(day, calendar);
			
		} else {
			if("delete".equals(request.getParameter("action"))){
				GroupCalendarService.deleteCalendar(calendar.id);
			} else {
				calendar.description = description;
				GroupCalendarService.saveCalendar(calendar);
				data.put(day, calendar);
			}
		}
		
		request.setAttribute("year", year);
		request.setAttribute("month", month);
		DateDto date = new DateDto();
		date.setDay(day);
		request.setAttribute("date", date);
		
		return "groupcal.jsp";
	}

}
