package net.sf.amateras.nikocale.action;

import java.net.URLEncoder;
import java.util.Date;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.persistence.jdbc.JdbcUtil;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.entity.Comment;
import net.sf.amateras.nikocale.entity.Entry;
import net.sf.amateras.nikocale.service.EntryService;

public class CommentAction implements IAction {
	
	@Request
	@Required
	public Long entryId;
	
	@Request(label="お名前")
	@Required
	public String name;
	
	@Request(label="コメント")
	@Required
	public String comment;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		Entry entry = EntryService.getEntry(entryId);
		
		Comment comment = new Comment();
		comment.entryId = this.entryId;
		comment.name = this.name;
		comment.comment = this.comment;
		comment.commentDate = new Date();
		
		JdbcUtil.insert(comment);
		
		entry.updateDate = new Date();
		EntryService.saveEntry(entry);
		
		// お名前をクッキーに保存
		Cookie cookie = new Cookie("NIKOCALE_NAME", URLEncoder.encode(this.name, "UTF-8"));
		cookie.setMaxAge(60 * 60 * 24 * 30);
		response.addCookie(cookie);
		
		response.sendRedirect(String.format(
				"entry.do?memberId=%d&year=%d&month=%d&day=%d",
				entry.userId, entry.year, entry.month, entry.day));
		return null;
	}

}
