package net.sf.amateras.nikocale.action;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.amateras.nikocale.entity.Entry;
import net.sf.amateras.nikocale.service.EntryService;
import net.sf.amateras.nikocale.service.MemberService;
import net.sf.amateras.nikocale.service.SystemInfoService;

public class AllAction extends AbstractNikocaleAction {

	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		setDateAttributes(request);
		
		request.setAttribute("title", String.format("すべてのニコカレ（%d年%d月）", year, month));
		request.setAttribute("members", MemberService.getAllMembers());
		
		Map<String, Entry> entries = EntryService.getEntries(year, month);
		for(Entry entry: entries.values()){
			if(entry.getCommentCount() != 0){
				entry.setMessage(entry.getMessage() + "(" + entry.getCommentCount() + "件のコメントがあります)");
			}
		}
		request.setAttribute("entries", entries);
		
		request.setAttribute("information", SystemInfoService.getInformation());
		request.setAttribute("recent", EntryService.getRecentEntries(5));
		request.setAttribute("top", EntryService.getRanking(true));
		request.setAttribute("bottom", EntryService.getRanking(false));
		request.setAttribute("mode", "all");
		
		return "all.jsp";
	}

}
