<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<%@ page language="java" contentType="text/xml; charset=UTF-8" pageEncoding="UTF-8" isELIgnored="false"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://nikonikofw.sf.net/f" prefix="f" %>
<%@ taglib uri="http://nikocale.amateras.sf.net/extension" prefix="ex" %>
<rdf:RDF xmlns="http://purl.org/rss/1.0/"
         xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
         xmlns:dc="http://purl.org/dc/elements/1.1/"
         xml:lang="ja">
  <channel rdf:about="${url}/index.do">
    <title>${f:h(title)}</title>
    <link>${url}/index.do</link>
    <dc:language>ja</dc:language>
    <c:if test="${!empty entries}">
      <dc:date>${ex:rssDate(entries[0].updateDate)}</dc:date>
    </c:if>
    
    <items>
      <rdf:Seq>
        <c:forEach items="${entries}" var="entry">
          <rdf:li rdf:resource="${url}/entry.do?memberId=${entry.userId}&amp;year=${entry.year}&amp;month=${entry.month}&amp;day=${entry.day}"/>
        </c:forEach>
      </rdf:Seq>
    </items>
  </channel>

  <c:forEach items="${entries}" var="entry">
    <item rdf:about="http://niko2cal.appspot.com/entry.do?userId=${entry.userId}&amp;year=${entry.year}&amp;month=${entry.month}&amp;day=${entry.day}">
      <title>${entry.year}年${entry.month}月${entry.day}日の${f:h(entry.memberName)}さん</title>
      <link>${url}/entry.do?memberId=${entry.userId}&amp;year=${entry.year}&amp;month=${entry.month}&amp;day=${entry.day}</link>
      <description>
        <c:if test="${entry.status == 0}">
          &lt;img src="${url}/images/good16.png" border="0" alt="[ニコニコ]" title="ニコニコ"&gt;（ニコニコ）
        </c:if>
        <c:if test="${entry.status == 1}">
          &lt;img src="${url}/images/normal16.png" border="0" alt="[普通]" title="普通"&gt;（普通）
        </c:if>
        <c:if test="${entry.status == 2}">
          &lt;img src="${url}/images/bad16.png" border="0" alt="[ダメダメ]" title="ダメダメ"&gt;（ダメダメ）
        </c:if>
        ${f:h(entry.message)}
        <c:if test="${!empty entry.commentCount && entry.commentCount != 0}">
          （${entry.commentCount}件のコメントがあります）
        </c:if>
      </description>
      <dc:date>${ex:rssDate(entry.updateDate)}</dc:date>
    </item>
  </c:forEach>

</rdf:RDF>
