﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _501スタッフ一覧 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

		//private enum enmスタッフ一覧Cell : int
		//{
		//    スタッフNo = 0,
		//    スタッフID = 1,
		//    パスワード = 2,
		//    役職No = 3,
		//    役職名 = 4,
		//    氏名 = 5,
		//    権限No = 6,
		//    権限名 = 7,
		//    備考 = 8
		//}
		private static class スタッフ一覧Cell
		{
            public const byte bytスタッフNo = 0;
            public const byte bytスタッフID = 1;
            public const byte bytパスワード = 2;
            public const byte byt役職No = 3;
            public const byte byt役職名 = 4;
            public const byte byt氏名 = 5;
            public const byte byt権限No = 6;
            public const byte byt権限名 = 7;
			public const byte byt備考 = 8;
		}

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _501スタッフ一覧()
        {
            InitializeComponent();
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set列幅()
        {
            dgvスタッフ一覧.Columns[スタッフ一覧Cell.bytスタッフNo].Visible = false;
            dgvスタッフ一覧.Columns[スタッフ一覧Cell.bytスタッフID].Width = C_列幅.顧客ID;
            dgvスタッフ一覧.Columns[スタッフ一覧Cell.bytパスワード].Visible = false;
            dgvスタッフ一覧.Columns[スタッフ一覧Cell.byt役職No].Visible = false;
            dgvスタッフ一覧.Columns[スタッフ一覧Cell.byt役職名].Width = C_列幅.役職名;
            dgvスタッフ一覧.Columns[スタッフ一覧Cell.byt氏名].Width = C_列幅.氏名;
            dgvスタッフ一覧.Columns[スタッフ一覧Cell.byt権限No].Visible = false;
            dgvスタッフ一覧.Columns[スタッフ一覧Cell.byt権限名].Width = C_列幅.権限名;
            dgvスタッフ一覧.Columns[スタッフ一覧Cell.byt備考].Width = C_列幅.備考;
        }

        private int Get選択行()
        {
            return dgvスタッフ一覧.SelectedCells[0].RowIndex;
        }


        #endregion



        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _109スタッフ一覧_Load(object sender, EventArgs e)
        {
            try
            {
                this.d12スタッフ一覧ta.Fill(this.d12スタッフ.D12スタッフ一覧);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_109スタッフ一覧", "_109スタッフ一覧_Load", ex);
            }
            finally
            {
                Set列幅();
            }
        }

        private void dgvスタッフ一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgvスタッフ一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgvスタッフ一覧.RowHeadersDefaultCellStyle.Font,
                                              dgvスタッフ一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_109スタッフ一覧", "dgvスタッフ一覧_RowPostPaint", ex);
            }
        }


        private void btn選択行をCSVファイルに出力_Click(object sender, EventArgs e)
        {
            try
            {
                if (dgvスタッフ一覧.SelectedRows.Count == 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_073, this.Text
						, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV ファイル(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

                Cursor.Current = Cursors.WaitCursor;

				C06CSV.CreateCSVファイル(dgvスタッフ一覧, sfd.FileName, true, 4, true, "");

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました
					, this.Text, MessageBoxButtons.OK , MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_109スタッフ一覧", "btn選択行をCSVファイルに出力_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }


        private void btn新規_Click(object sender, EventArgs e)
        {
            try
            {
                _502スタッフ詳細 _502スタッフ詳細 = null;
                _502スタッフ詳細 = new _502スタッフ詳細();
                _502スタッフ詳細.ShowDialog();

                this.d12スタッフ一覧ta.Fill(this.d12スタッフ.D12スタッフ一覧);

                MessageBox.Show(Properties.Resources.MSG_INF_スタッフの登録が完了しました, this.Text
					, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_109スタッフ一覧", "btn新規_Click", ex);
            }
        }

        private void btn変更_Click(object sender, EventArgs e)
        {
            try
            {
                if (dgvスタッフ一覧.SelectedCells.Count == 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_セルが選択されていません, this.Text
						, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                _502スタッフ詳細 _502スタッフ詳細 = null;
                _502スタッフ詳細 = new _502スタッフ詳細();
                _502スタッフ詳細.miスタッフNo = int.Parse(dgvスタッフ一覧.Rows[Get選択行()]
					.Cells[スタッフ一覧Cell.bytスタッフNo].Value.ToString());
                _502スタッフ詳細.mstrスタッフID = dgvスタッフ一覧.Rows[Get選択行()]
					.Cells[スタッフ一覧Cell.bytスタッフID].Value.ToString();
                _502スタッフ詳細.mstrパスワード = dgvスタッフ一覧.Rows[Get選択行()]
					.Cells[スタッフ一覧Cell.bytパスワード].Value.ToString();
                _502スタッフ詳細.mi役職No = int.Parse(dgvスタッフ一覧.Rows[Get選択行()]
					.Cells[スタッフ一覧Cell.byt役職No].Value.ToString());
                _502スタッフ詳細.mstr氏名 = dgvスタッフ一覧.Rows[Get選択行()]
					.Cells[スタッフ一覧Cell.byt氏名].Value.ToString();
                _502スタッフ詳細.mi権限No = int.Parse(dgvスタッフ一覧.Rows[Get選択行()]
					.Cells[スタッフ一覧Cell.byt権限No].Value.ToString());
                _502スタッフ詳細.mstr備考 = dgvスタッフ一覧.Rows[Get選択行()]
					.Cells[スタッフ一覧Cell.byt備考].Value.ToString();
				if (_502スタッフ詳細.ShowDialog() == DialogResult.Cancel)
					return;

                this.d12スタッフ一覧ta.Fill(this.d12スタッフ.D12スタッフ一覧);

                MessageBox.Show(Properties.Resources.MSG_I_スタッフの更新が完了しました, this.Text
					, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_109スタッフ一覧", "btn変更_Click", ex);
            }
        }

        private void btn削除_Click(object sender, EventArgs e)
        {
            try
            {
                DataGridViewRow row = dgvスタッフ一覧.SelectedRows[0];

                if ((int)row.Cells[スタッフ一覧Cell.bytスタッフNo].Value == C02業務共通処理.miログインスタッフNo)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_削除対象のスタッフは_ログイン中の為_削除できません
						, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                if (d12スタッフta.Scalar管理スタッフ総数((int)row.Cells[スタッフ一覧Cell.bytスタッフNo].Value) == 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_管理者を0人にする事はできません, this.Text
						, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }


                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_選択されいる行を削除しますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                string str削除済みスタッフID = "";
                //foreach (DataGridViewRow row in dgvスタッフ一覧.SelectedRows)
                //{

                d12スタッフta.Delete((int)row.Cells[スタッフ一覧Cell.bytスタッフNo].Value);
                str削除済みスタッフID += row.Cells[スタッフ一覧Cell.bytスタッフID].Value.ToString() + ", ";

                //}

                this.d12スタッフ一覧ta.Fill(this.d12スタッフ.D12スタッフ一覧);

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_022
                    + "=" + str削除済みスタッフID.Substring(0, str削除済みスタッフID.Length - 2));

                MessageBox.Show(Properties.Resources.MSG_I_スタッフの削除が完了しました, this.Text
					, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_109スタッフ一覧", "btn削除_Click", ex);
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_109スタッフ一覧", "btnキャンセル_Click", ex);
            }
        }

        #endregion



    }
}
