﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
//using System.Reflection;
using System.Globalization;
using System.Data.SqlClient;
using System.Linq;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _201販売履歴 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // 内部クラス
        ////////////////////////////////////////////////////////////////////////
        #region CSV取込処理内部クラス
        private class 取込処理内部クラス : C03CSV取込処理基底
        {
			//private enum enmCSV取込列
			//{
			//    販売日時 = 0,
			//    商品ID = 1,
			//    商品名 = 2,
			//    商品単価 = 3,
			//    販売個数 = 4,
			//    顧客ID = 5
			//}
			private static class CSV取込列
			{
                public const byte byt販売日時 = 0;
                public const byte byt商品ID = 1;
                public const byte byt商品名 = 2;
                public const byte byt商品単価 = 3;
                public const byte byt販売個数 = 4;
				public const byte byt顧客ID = 5;
			}

            protected override int 基底CSV取込クラスからの列数取得()
            {
                return CSV取込列.byt顧客ID + 1;
            }

            protected override bool 基底CSV取込クラスからの検証(int rowIndex, int colIndex, string value)
            {
                switch (colIndex)
                {
                    case CSV取込列.byt販売日時:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, C_最大文字数.日時, C_正規表現.半角英数
                            , Properties.Resources.DGV列名_販売日時))
                            return false;

                        // 日付型チェック
                        DateTime dt;
                        if (DateTime.TryParse(value, out dt) == false)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aが日付として正しくありません
                                , Properties.Resources.DGV列名_販売日時);
                            return false;
                        }

                        // 日付範囲チェック
                        if (dt.Year < C_最小値.年 || C_最大値.年 < dt.Year)
                        {
                            mErrorDetail = string.Format(Properties.Resources.MSG_W_Aには_B_C年以外の値を_入力できません
                                , Properties.Resources.DGV列名_販売日時, C_最小値.年, C_最大値.年);
                            return false;
                        }

                        break;

                    case CSV取込列.byt顧客ID:

                        //必須入力、桁数、書式検証
                        if (C02業務共通処理.分析手法を取得() == enm分析手法.顧客分析.ToString())
                        {
                            if (!IsValidate共通(value, true, C_最大文字数.商品ID, C_正規表現.半角英数
                                , Properties.Resources.DGV列名_顧客ID))
                                return false;
                        }
                        else if (C02業務共通処理.分析手法を取得() == enm分析手法.バスケット分析.ToString())
                        {
                            if (!IsValidate共通(value, true, C_最大文字数.商品ID, C_正規表現.半角英数
                                , Properties.Resources.DGV列名_バスケットNo))
                                return false;
                        }

                        break;

                    case CSV取込列.byt商品ID:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, C_最大文字数.商品ID, C_正規表現.半角英数
                            , Properties.Resources.DGV列名_商品ID))
                            return false;

                        ////DB重複チェック
                        //if (!IsExsist商品ID(value, ((enmCSV取込列)colIndex).ToString()))
                        //    return false;

                        break;
                    case CSV取込列.byt商品名:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, C_最大文字数.商品名, C_正規表現.なし
                            , Properties.Resources.DGV列名_商品名))
                            return false;

                        break;
                    case CSV取込列.byt商品単価:
                        //必須入力、桁数、書式検証
                        value = value.Replace(",", string.Empty);
                        if (!IsValidate共通(value, true, C_最大文字数.商品単価, C_正規表現.半角数字
                            , Properties.Resources.DGV列名_商品単価))
                            return false;

                        break;

                    case CSV取込列.byt販売個数:
                        //必須入力、桁数、書式検証
                        value = value.Replace(",", string.Empty);
                        if (!IsValidate共通(value, true, C_最大文字数.販売個数, C_正規表現.半角数字
                            , Properties.Resources.DGV列名_販売個数))
                            return false;

                        break;
                }
                return true;
            }

            protected override void 基底CSV取込クラスからのデータ変換(int rowIndex, List<string> values, DataTable dt)
            {
                D03販売履歴.D03販売履歴DataTable dt販売履歴 = (D03販売履歴.D03販売履歴DataTable)dt;
                D03販売履歴.D03販売履歴Row row = dt販売履歴.NewD03販売履歴Row();

                row.新規 = true;
                row.販売日時 = DateTime.Parse(values[CSV取込列.byt販売日時]);
                row.商品ID = values[CSV取込列.byt商品ID];
                row.商品名 = values[CSV取込列.byt商品名];
                string strTmp = values[CSV取込列.byt商品単価].Replace(",", "");
                row.商品単価 = long.Parse(strTmp);
                row.販売個数 = long.Parse(values[CSV取込列.byt販売個数]);
				row.顧客ID = values[CSV取込列.byt顧客ID];

                dt販売履歴.AddD03販売履歴Row(row);
            }
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

		private class 検索条件
        {
            public DateTime 販売日fr { get; set; }
            public DateTime 販売日to { get; set; }
            public string 商品ID { get; set; }
            public string 商品名 { get; set; }
            public Nullable<long> 商品単価 { get; set; }
            public string 顧客ID { get; set; }
        }

		//private enum enm販売履歴Cell
		//{
		//    新規 = 0,
		//    変更 = 1,
		//    削除 = 2,
		//    販売履歴No = 3,
		//    販売日時 = 4,
		//    商品ID = 5,
		//    商品名 = 6,
		//    商品単価 = 7,
		//    販売個数 = 8,
		//    顧客ID = 9,
		//    商品No = 10,
		//    顧客No = 11
		//}
		private static class 販売履歴Cell
		{
            public const byte byt新規 = 0;
			public const byte byt変更 = 1;
			public const byte byt削除 = 2;
			public const byte byt販売履歴No = 3;
			public const byte byt販売日時 = 4;
			public const byte byt商品ID = 5;
			public const byte byt商品名 = 6;
			public const byte byt商品単価 = 7;
			public const byte byt販売個数 = 8;
			public const byte byt顧客ID = 9;
			public const byte byt商品No = 10;
			public const byte byt顧客No = 11;
		}
		

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _201販売履歴()
        {
            InitializeComponent();
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド Static

		//最終行でかつ全項目未入力となっているかを返す
		private static bool 最終行or全項目未入力(DataGridView dgv, int rowIndex)
		{
			if ((dgv.RowCount - 1) != rowIndex)
				return false;

			if ((dgv.Rows[rowIndex].Cells[販売履歴Cell.byt販売日時].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[販売履歴Cell.byt商品ID].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[販売履歴Cell.byt商品名].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[販売履歴Cell.byt商品単価].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[販売履歴Cell.byt販売個数].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[販売履歴Cell.byt顧客ID].FormattedValue.ToString() == string.Empty))
			{
				return true;
			}

			return false;
		}

		private static bool IsValidateDGV販売履歴(DataGridView dgv, int iRow)
		{
			if (iRow < 0)
				return true;

			bool ret = true;

			if (最終行or全項目未入力(dgv, iRow))
				return ret;

			for (int iCol = 0; iCol < dgv.ColumnCount; iCol++)
			{
				string value = dgv.Rows[iRow].Cells[iCol].FormattedValue.ToString();

				switch (iCol)
				{
					case 販売履歴Cell.byt販売日時:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell日時型(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;

					case 販売履歴Cell.byt商品ID:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell半角入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;

					case 販売履歴Cell.byt顧客ID:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell禁止文字(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell半角入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;

					case 販売履歴Cell.byt商品名:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;

					case 販売履歴Cell.byt商品単価:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell通貨型(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (IsValidate販売金額(dgv, iRow) == false)
						{
							ret = false;
							break;
						}

						break;

					case 販売履歴Cell.byt販売個数:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell符号無し数値型(dgv, iRow, iCol, value))
						//if (!C11ValidateOnForm.IsValidateCell通貨型(dgv販売履歴, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (IsValidate販売金額(dgv, iRow) == false)
						{
							ret = false;
							break;
						}

						break;
				}
			}

			return ret;
		}

		private static bool IsValidate未入力行(DataGridViewRow row)
		{
			if ((row.Cells[販売履歴Cell.byt販売日時].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[販売履歴Cell.byt商品ID].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[販売履歴Cell.byt商品名].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[販売履歴Cell.byt商品単価].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[販売履歴Cell.byt販売個数].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[販売履歴Cell.byt顧客ID].FormattedValue.ToString() == string.Empty))
				return true;
			else
				return false;
		}

		private static bool IsValidate新規変更削除チェック状態(DataGridView dgv, string strFormTitle)
		{
			for (int iRow = 0; iRow < dgv.RowCount; iRow++)
			{
				if (最終行or全項目未入力(dgv, iRow) == true)
					continue;

				if ((Boolean)dgv.Rows[iRow].Cells[販売履歴Cell.byt新規].Value == false &&
					(Boolean)dgv.Rows[iRow].Cells[販売履歴Cell.byt変更].Value == false &&
					(Boolean)dgv.Rows[iRow].Cells[販売履歴Cell.byt削除].Value == false)
					continue;

				string strErrMsg = "";
				if (!C11ValidateOnForm.IsValidate新規変更削除チェック状態(dgv, iRow,
					販売履歴Cell.byt新規, 販売履歴Cell.byt変更, 販売履歴Cell.byt削除,
					販売履歴Cell.byt販売履歴No, ref strErrMsg))
				{
					MessageBox.Show(strErrMsg, strFormTitle, MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return false;
				}
			}

			return true;
		}

		private static bool IsValidate販売金額(DataGridView dgv, int iRow)
		{
			// どちらかが未入力だったら、なにもしない。
			if (dgv.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value.ToString() == "" ||
				dgv.Rows[iRow].Cells[販売履歴Cell.byt販売個数].Value.ToString() == "")
				return true;

			if (dgv.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value.ToString() == "1" ||
				dgv.Rows[iRow].Cells[販売履歴Cell.byt販売個数].Value.ToString() == "1")
				return true;

			int int桁数 = dgv.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value.ToString().Length +
				dgv.Rows[iRow].Cells[販売履歴Cell.byt販売個数].Value.ToString().Length;

			//if (((long.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value.ToString()) *
			//    long.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売個数].Value.ToString())))
			//    > (long)C_最大値.販売金額)
			if (int桁数 > ((long)C_最大値.販売金額).ToString().Length)
			{
				dgv.Rows[iRow].Cells[販売履歴Cell.byt商品単価].ErrorText
					= string.Format(Properties.Resources.MSG_W_商品単価と販売個数をかけた値が_Aを超えています
					, string.Format("{0:#,0}", (long)C_最大値.販売金額));
				dgv.Rows[iRow].Cells[販売履歴Cell.byt販売個数].ErrorText
					= string.Format(Properties.Resources.MSG_W_商品単価と販売個数をかけた値が_Aを超えています
					, string.Format("{0:#,0}", (long)C_最大値.販売金額));

				return false;
			}

			return true;
		}

		private static void Format金額列(ref DataGridView dgv)
		{
			for (int iRow = 0; iRow < dgv.RowCount; iRow++)
			{
				//decimal decRes = (decimal)dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value;
				string str = string.Format("{0:#,0}", dgv.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value);
				dgv.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value = str;
				//str = str.ToString("#,##0");

				//dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value =
			}
		}

		#endregion


		#region 非公開 共通メソッド Non Static
		
		private void Set列幅()
        {
			//dgv販売履歴.Columns[販売履歴Cell.byt新規].Visible = false;
			//dgv販売履歴.Columns[販売履歴Cell.byt変更].Visible = false;
			//dgv販売履歴.Columns[販売履歴Cell.byt削除].Width = C_列幅.削除;
			//dgv販売履歴.Columns[販売履歴Cell.byt販売履歴No].Visible = false;
			//dgv販売履歴.Columns[販売履歴Cell.byt販売日時].Width = C_列幅.日時;
			//dgv販売履歴.Columns[販売履歴Cell.byt商品ID].Width = C_列幅.商品ID;
			//dgv販売履歴.Columns[販売履歴Cell.byt商品名].Width = C_列幅.商品名;
			//dgv販売履歴.Columns[販売履歴Cell.byt商品単価].Width = C_列幅.商品単価;
			//dgv販売履歴.Columns[販売履歴Cell.byt販売個数].Width = C_列幅.販売個数;
			//dgv販売履歴.Columns[販売履歴Cell.byt顧客ID].Width = C_列幅.顧客ID;
			dgv販売履歴.Columns[販売履歴Cell.byt新規].Visible = false;
			dgv販売履歴.Columns[販売履歴Cell.byt変更].Visible = false;
			dgv販売履歴.Columns[販売履歴Cell.byt削除].Width = C_列幅.削除;
            dgv販売履歴.Columns[販売履歴Cell.byt販売履歴No].Visible = false;
            dgv販売履歴.Columns[販売履歴Cell.byt販売日時].Width = C_列幅.日時;
            dgv販売履歴.Columns[販売履歴Cell.byt商品ID].Width = C_列幅.商品ID;
            dgv販売履歴.Columns[販売履歴Cell.byt商品名].Width = C_列幅.商品名;
            dgv販売履歴.Columns[販売履歴Cell.byt商品単価].Width = C_列幅.商品単価;
            dgv販売履歴.Columns[販売履歴Cell.byt販売個数].Width = C_列幅.販売個数;
            dgv販売履歴.Columns[販売履歴Cell.byt顧客ID].Width = C_列幅.顧客ID;
			
        }

		//検索で使用するSQLパラメータの取得
		private 検索条件 Get検索条件()
		{
			検索条件 row = new 検索条件();

			if (dtp販売日fr.Checked == true)
				row.販売日fr = dtp販売日fr.Value.Date;
			else
				row.販売日fr = dtp販売日fr.MinDate;

			if (dtp販売日to.Checked == true)
				row.販売日to = dtp販売日to.Value.Date.AddDays(1).AddSeconds(-1);
			else
				row.販売日to = dtp販売日to.MaxDate;

			if (txt商品ID.Text == "")
				row.商品ID = null;
			else
				row.商品ID = txt商品ID.Text;

			if (txt商品名.Text == "")
				row.商品名 = null;
			else
				row.商品名 = txt商品名.Text;

			if (txt商品単価.Text == "")
				row.商品単価 = null;
			else
				row.商品単価 = long.Parse(txt商品単価.Text);

			if (txt顧客ID.Text == "")
				row.顧客ID = null;
			else
				row.顧客ID = txt顧客ID.Text;

			return row;
		}

		private bool IsValidate検索()
		{
			if (txt商品ID.Text != "")
			{
				if (C11ValidateOnForm.IsValidate半角英数(txt商品ID.Text
					, Properties.Resources.DGV列名_商品ID) == false)
					return false;
			}

			if (txt商品単価.Text != "")
			{
				if (C11ValidateOnForm.IsValidate符号無し数値型(txt商品単価.Text
					, Properties.Resources.DGV列名_商品単価) == false)
					return false;
			}

			if (txt顧客ID.Text != "")
			{
				if (C02業務共通処理.分析手法を取得() == enm分析手法.顧客分析.ToString())
				{
					if (C11ValidateOnForm.IsValidate半角英数(txt顧客ID.Text
						, Properties.Resources.DGV列名_顧客ID) == false)
						return false;
				}
				else if (C02業務共通処理.分析手法を取得() == enm分析手法.バスケット分析.ToString())
				{
					if (C11ValidateOnForm.IsValidate半角英数(txt顧客ID.Text
						, Properties.Resources.DGV列名_バスケットNo) == false)
						return false;
				}
			}

			return true;
		}

		//入力値検証
        private bool IsValidate()
        {
            //最大登録件数チェック
            D03販売履歴.D03販売履歴Row[] dr = (D03販売履歴.D03販売履歴Row[])d03販売履歴._D03販売履歴
                .Select(Properties.Resources.DGV列名_新規 + " = true");
            //int intCnt = (int)d03販売履歴ta.Scalar販売履歴Cnt() + dr.Length;
            //if (intCnt > C_最大値.登録件数)
            //{
            //    string msg = string.Format(Properties.Resources.MSG_INF_101, C_最大値.登録件数);
            //    MessageBox.Show(msg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            //    dgv販売履歴.Focus();
            //    return false;
            //}

            //必須入力欄
			if ((dgv販売履歴.RowCount == 1) && (最終行or全項目未入力(dgv販売履歴, 0)))
            {
                MessageBox.Show(Properties.Resources.MSG_W_販売履歴が入力されていません, this.Text, MessageBoxButtons.OK
                    , MessageBoxIcon.Warning);
                dgv販売履歴.Focus();
                return false;
            }

            //最大値確定件数チェック
            dr = (D03販売履歴.D03販売履歴Row[])d03販売履歴._D03販売履歴.Select(Properties.Resources.DGV列名_新規+ " = true or " +
                Properties.Resources.DGV列名_変更 + " = true or " + Properties.Resources.DGV列名_削除 + " = true");

            if (dr.Length > C_最大値.確定件数)
            {
                MessageBox.Show(string.Format(Properties.Resources.MSG_W_編集された行数が_最大数A件_を超えています, C_最大値.CSV取込件数), this.Text
                    , MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }

			if (IsValidate新規変更削除チェック状態(dgv販売履歴, this.Text) == false)
                return false;

            //未入力
            bool b新規変更削除にチェック有り = false;
            for (int iRow = 0; iRow < dgv販売履歴.RowCount; iRow++)
            {
				if (最終行or全項目未入力(dgv販売履歴, iRow) == true)
                    continue;

                if ((Boolean)dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt新規].Value == false &&
                    (Boolean)dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt変更].Value == false &&
                    (Boolean)dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt削除].Value == false)
                    continue;

                b新規変更削除にチェック有り = true;
                break;
            }

            if (b新規変更削除にチェック有り == false)
            {
                MessageBox.Show(Properties.Resources.MSG_W_編集された行がありません, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Warning);
                dgv販売履歴.Focus();
                return false;
            }

            //編集されたセルを全てチェックする
            bool isValid = true;
            for (int iRow = 0; iRow < dgv販売履歴.RowCount; iRow++)
            {
				if (最終行or全項目未入力(dgv販売履歴, iRow) == true)
                    continue;

                if ((Boolean)dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt新規].Value == false &&
                    (Boolean)dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt変更].Value == false &&
                    (Boolean)dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt削除].Value == false)
                    continue;

				if (!IsValidateDGV販売履歴(dgv販売履歴, iRow))
                    isValid = false;

                //dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売個数].ErrorText = string.Empty;
                //dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].ErrorText = string.Empty;
            }

            if (!isValid)
            {
                MessageBox.Show(string.Format(Properties.Resources.MSG_W_Aの入力内容に誤りがある為_登録を完了できません
					, Properties.Resources.MSG_TTL_販売履歴)
                    , this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

                dgv販売履歴.Focus();
                return false;
            }

            return true;
        }

        private void Insert販売履歴()
        {
            D03販売履歴.D03販売履歴Row[] dr = (D03販売履歴.D03販売履歴Row[])d03販売履歴._D03販売履歴
                .Select(Properties.Resources.DGV列名_新規 + " = true");

            string str販売日時と商品IDリスト = "";
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                int int商品No = C02業務共通処理.Get商品No(dr[iRow].商品ID, dr[iRow].商品名, dr[iRow].商品単価);

                int int顧客No = C02業務共通処理.Get顧客No(dr[iRow].顧客ID);

                // H01販売履歴に登録
                d03販売履歴ta.Insert(   dr[iRow].販売日時, 
                                        dr[iRow].商品ID, 
                                        dr[iRow].商品名, 
                                        dr[iRow].商品単価,
                                        dr[iRow].販売個数, 
                                        dr[iRow].商品単価 * dr[iRow].販売個数,
                                        dr[iRow].顧客ID, 
                                        int商品No, 
                                        int顧客No,
                                        C02業務共通処理.miログインスタッフNo);

                str販売日時と商品IDリスト += dr[iRow].販売日時 + " " + dr[iRow].商品ID + ", ";
            }

            if (dr.Length > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_004
                     + "=" + str販売日時と商品IDリスト.Substring(0, str販売日時と商品IDリスト.Length - 2));

            ////先頭１行だけSelectされない、.Netのバグに対応する為、１行目の処理だけ別で行う。
            //if (dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt新規].Value != null)
            //    if ((Boolean)dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt新規].Value != false)
            //    {
            //        Nullable<int> int商品No = Get商品No(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品ID].Value.ToString()
            //                                          , dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品名].Value.ToString()
            //                                          , int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品単価].Value.ToString()));

            //        Nullable<int> int顧客No = Get顧客No(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt顧客ID].Value.ToString());

            //        d03販売履歴ta.Insert(DateTime.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt販売日時].Value.ToString()),
            //                              dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品ID].Value.ToString(),
            //                              dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品名].Value.ToString(),
            //                              int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品単価].Value.ToString()),
            //                              int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt販売個数].Value.ToString()),
            //                              int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品単価].Value.ToString()) *
            //                              int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt販売個数].Value.ToString()),
            //                              dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt顧客ID].Value.ToString(),
            //                              int商品No, int顧客No);
            //    }

            //for (int iRow = 0; iRow < dgv販売履歴.RowCount - 1; iRow++)
            //{
            //    if (dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt新規].Value == null)
            //        continue;

            //    if ((Boolean)dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt新規].Value == false)
            //        continue;

            //    Nullable<int> int商品No = Get商品No(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品ID].Value.ToString()
            //                                      , dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品名].Value.ToString()
            //                                      , int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value.ToString()));

            //    Nullable<int> int顧客No = Get顧客No(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt顧客ID].Value.ToString());

            //    // H01販売履歴に登録
            //    d03販売履歴ta.Insert(DateTime.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売日時].Value.ToString()),
            //                          dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品ID].Value.ToString(),
            //                          dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品名].Value.ToString(),
            //                          int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value.ToString()),
            //                          int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売個数].Value.ToString()),
            //                          int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value.ToString()) *
            //                          int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売個数].Value.ToString()),
            //                          dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt顧客ID].Value.ToString(),
            //                          int商品No, int顧客No);
            //}
        }

        //public void M02商品_更新()
        //{
        //    d03商品ta.DeleteALL();

        //    Nullable<int> int商品No = Get商品No(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品ID].Value.ToString()
        //                                      , dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品名].Value.ToString()
        //                                      , int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value.ToString()));


        //    // 商品IDが、M02商品に登録されているかチェック
        //    if (d03商品ta.Scalar同一商品ID(str商品ID) == 0)
        //    {
        //        //登録されていなかったら、新商品として、M02商品に登録。
        //        d03商品ta.Insert(str商品ID, str商品名, int商品単価);
        //    }

        //    D03販売履歴.D03商品DataTable dt商品 = new D03販売履歴.D03商品DataTable();
        //    d03商品ta.FillBy商品No取得(dt商品, str商品ID);
        //    return dt商品[0].商品No;

        //}

        private void Update販売履歴()
        {
            D03販売履歴.D03販売履歴Row[] dr = (D03販売履歴.D03販売履歴Row[])d03販売履歴._D03販売履歴
                .Select(Properties.Resources.DGV列名_変更 + " = true");

            string str販売日時と商品IDリスト = "";
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
                int int商品No = C02業務共通処理.Get商品No(dr[iRow].商品ID, dr[iRow].商品名, dr[iRow].商品単価);

                int int顧客No = C02業務共通処理.Get顧客No(dr[iRow].顧客ID);

                // H01販売履歴 を更新
                d03販売履歴ta.Update(dr[iRow].販売日時,
                                      dr[iRow].商品ID,
                                      dr[iRow].商品名,
                                      dr[iRow].商品単価,
                                      dr[iRow].販売個数,
                                      dr[iRow].商品単価 * dr[iRow].販売個数,
                                      dr[iRow].顧客ID,
                                      int商品No,
                                      int顧客No,
                                      C02業務共通処理.miログインスタッフNo,
                                      dr[iRow].販売履歴No);

                //d03商品ta.Update(dr[iRow].商品名, dr[iRow].商品単価, int商品No);

                str販売日時と商品IDリスト += dr[iRow].販売日時 + " " + dr[iRow].商品ID + ", ";
            }

            if (dr.Length > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_005
                     + "=" + str販売日時と商品IDリスト.Substring(0, str販売日時と商品IDリスト.Length - 2));

            ////先頭１行だけSelectされない、.Netのバグに対応する為、１行目の処理だけ別で行う。
            //if (dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt変更].Value != null)
            //    if ((Boolean)dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt変更].Value != false)
            //    {
            //        Nullable<int> int商品No = Get商品No(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品ID].Value.ToString()
            //                                          , dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品名].Value.ToString()
            //                                          , int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品単価].Value.ToString()));

            //        Nullable<int> int顧客No = Get顧客No(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt顧客ID].Value.ToString());
                
            //        d03販売履歴ta.Update(DateTime.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt販売日時].Value.ToString()),
            //                              dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品ID].Value.ToString(),
            //                              dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品名].Value.ToString(),
            //                              int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品単価].Value.ToString()),
            //                              int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt販売個数].Value.ToString()),
            //                              int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt商品単価].Value.ToString()) *
            //                              int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt販売個数].Value.ToString()),
            //                              dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt顧客ID].Value.ToString(),
            //                              int商品No,
            //                              int顧客No,
            //                              int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt販売履歴No].Value.ToString()));
            //    }

            //for (int iRow = 0; iRow < dgv販売履歴.RowCount; iRow++)
            //{
            //    if (dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt変更].Value == null)
            //        continue;

            //    if ((Boolean)dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt変更].Value == false)
            //        continue;

            //    if (dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売履歴No].Value.ToString() == "")
            //        continue;

            //    Nullable<int> int商品No = Get商品No(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品ID].Value.ToString()
            //                                      , dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品名].Value.ToString()
            //                                      , int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value.ToString()));

            //    Nullable<int> int顧客No = Get顧客No(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt顧客ID].Value.ToString());

            //    // H01販売履歴 を更新
            //    d03販売履歴ta.Update(DateTime.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売日時].Value.ToString()),
            //                          dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品ID].Value.ToString(),
            //                          dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品名].Value.ToString(),
            //                          int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value.ToString()),
            //                          int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売個数].Value.ToString()),
            //                          int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value.ToString()) *
            //                          int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売個数].Value.ToString()),
            //                          dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt顧客ID].Value.ToString(),
            //                          int商品No,
            //                          int顧客No,
            //                          int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売履歴No].Value.ToString()));
            //}

        }
		
        private void Delete販売履歴()
        {
            //D03販売履歴.D03販売履歴Row[] dr = (D03販売履歴.D03販売履歴Row[])d03販売履歴._D03販売履歴.Select("削除 = true");

            //for (int iRow = 0; iRow < dr.Length; iRow++)
            //{
            //    // H01販売履歴 から削除
            //    d03販売履歴ta.Delete(dr[iRow].販売履歴No);
            //}

            ////先頭１行だけSelectされない、.Netのバグに対応する為、１行目の処理だけ別で行う。
            //if (dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt削除].Value != null)
            //    if ((Boolean)dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt削除].Value != false)
            //        d03販売履歴ta.Delete(int.Parse(dgv販売履歴.Rows[0].Cells[販売履歴Cell.byt販売履歴No].Value.ToString()));

            string str販売日時と商品IDリスト = "";
            int i削除行数 = 0;
            for (int iRow = 0; iRow < dgv販売履歴.RowCount; iRow++)
            {
                if (dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt削除].Value == null)
                    continue;

                if ((Boolean)dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt削除].Value == false)
                    continue;

                if (dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売履歴No].Value.ToString() == "")
                    continue;

                // H01販売履歴 から削除
                d03販売履歴ta.Delete(int.Parse(dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売履歴No].Value.ToString()));

                str販売日時と商品IDリスト += dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt販売日時].Value.ToString()
                    + " " + dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品ID].Value.ToString() + ", ";

                i削除行数++;
            }

            if (i削除行数 > 0)
                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_006
                    + "=" + str販売日時と商品IDリスト.Substring(0, str販売日時と商品IDリスト.Length - 2));

            // 2010-3-4 1.2.0.1 START
            //d03商品ta.Delete販売履歴で使われていない商品();
            // 2010-3-4 1.2.0.1 END 
        }
		
        #endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _201販売履歴_Load(object sender, EventArgs e)
        {
            try
            {
                ////列サイズ調整
                //dgv販売履歴.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;
                //dgv販売履歴.Columns[販売履歴Cell.byt新規].MinimumWidth = (int)enmグリッド列最小サイズ.新規;
                //dgv販売履歴.Columns[販売履歴Cell.byt変更].MinimumWidth = (int)enmグリッド列最小サイズ.変更;
                //dgv販売履歴.Columns[販売履歴Cell.byt削除].MinimumWidth = (int)enmグリッド列最小サイズ.削除;
                //dgv販売履歴.Columns[販売履歴Cell.byt販売日時].MinimumWidth = (int)enmグリッド列最小サイズ.販売日時;
                //dgv販売履歴.Columns[販売履歴Cell.byt商品ID].MinimumWidth = (int)enmグリッド列最小サイズ.商品ID;
                //dgv販売履歴.Columns[販売履歴Cell.byt商品名].MinimumWidth = (int)enmグリッド列最小サイズ.商品名;
                //dgv販売履歴.Columns[販売履歴Cell.byt商品単価].MinimumWidth = (int)enmグリッド列最小サイズ.商品単価;
                //dgv販売履歴.Columns[販売履歴Cell.byt販売個数].MinimumWidth = (int)enmグリッド列最小サイズ.販売個数;
                //dgv販売履歴.Columns[販売履歴Cell.byt顧客ID].MinimumWidth = (int)enmグリッド列最小サイズ.顧客ID;

                if (C02業務共通処理.分析手法を取得() == enm分析手法.バスケット分析.ToString())
                {
                    lbl顧客ID.Text = Properties.Resources.DGV列名_バスケットNo + "：";
                    dgv販売履歴.Columns[販売履歴Cell.byt顧客ID].HeaderText = Properties.Resources.DGV列名_バスケットNo;
                    txt顧客ID.Left = lbl顧客ID.Left + lbl顧客ID.Width ;
                }

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "_201販売履歴_Load", ex);
            }
            finally
            {
                Set列幅();
            }
        }

        private void _201販売履歴_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, true);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "_201販売履歴_Resize", ex);
            }
        }

        private void dgv販売履歴_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv販売履歴.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv販売履歴.RowHeadersDefaultCellStyle.Font,
                                              dgv販売履歴.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "dgv販売履歴_RowPostPaint", ex);
            }
        }

        private void btn検索条件をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                dtp販売日fr.Value = DateTime.Today;
                dtp販売日to.Value = DateTime.Today;
                dtp販売日fr.Checked = false;
                dtp販売日to.Checked = false;
                txt商品ID.Text = "";
                txt商品名.Text = "";
                txt商品単価.Text = "";
                txt顧客ID.Text = "";
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "btn検索条件をクリア_Click", ex);
            }
        }

        private void btn検索_Click(object sender, EventArgs e)
        {
            try
            {
				if (IsValidate検索() == false)
					return;

                Cursor.Current = Cursors.WaitCursor;
                //dgv販売履歴.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;
                d03販売履歴bs.DataSource = null;

                検索条件 row = Get検索条件();

                //検索実行
                d03販売履歴ta.FillBy検索(d03販売履歴._D03販売履歴, 
                    row.販売日fr, 
                    row.販売日to, 
                    row.商品ID, 
                    row.商品名, 
                    row.商品単価, 
                    row.顧客ID);

                //見つからない場合はメッセージ表示
				if (d03販売履歴._D03販売履歴.Rows.Count == 0)
				{
					MessageBox.Show(Properties.Resources.MSG_W_データは見つかりませんでした
						, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
				}
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "btn検索_Click", ex);
            }
            finally
            {
                d03販売履歴bs.DataSource = d03販売履歴._D03販売履歴;
				lbl件数.Text = "検索結果：" + d03販売履歴._D03販売履歴.Count.ToString() + " 件";
                //dgv販売履歴.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;

                //Format金額列();

                Cursor.Current = Cursors.Arrow;
            }
        }

        private void dgv販売履歴_CellBeginEdit(object sender, DataGridViewCellCancelEventArgs e)
        {
            try
            {
                // 書式変更
                switch (e.ColumnIndex)
                {
                    case 販売履歴Cell.byt商品単価:
                        if (dgv販売履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].Value != null)
                        {
                            DataGridViewCellStyle style = new DataGridViewCellStyle();
                            style.Alignment = DataGridViewContentAlignment.MiddleRight;
                            style.Format = "#0";
                            dgv販売履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].Style = style;
                        }
                        break;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "dgv販売履歴_CellBeginEdit", ex);
            }
        }

        private void dgv販売履歴_CellEndEdit(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                // 書式変更
                switch (e.ColumnIndex)
                {
                    case 販売履歴Cell.byt商品単価:
                        if (dgv販売履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].Value != null)
                        {
                            DataGridViewCellStyle style = new DataGridViewCellStyle();
                            style.Alignment = DataGridViewContentAlignment.MiddleRight;
                            style.Format = "#,##0";
                            dgv販売履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].Style = style;
                        }
                        break;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "dgv販売履歴_CellEndEdit", ex);
            }
        }

        private void dgv販売履歴_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            try
            {

                //if (e.RowIndex < 0)
                //    return;

                //if (e.ColumnIndex < 3)
                //    return;

                //if (dgv販売履歴.Rows[e.RowIndex].Cells[販売履歴Cell.byt販売履歴No].Value == null)
                //    return;

                //if (dgv販売履歴.Rows[e.RowIndex].Cells[販売履歴Cell.byt販売履歴No].Value.ToString() != "")
                //{
                //    // 「変更」列をチェック状態にする
                //    dgv販売履歴.Rows[e.RowIndex].Cells[販売履歴Cell.byt新規].Value = false;
                //    dgv販売履歴.Rows[e.RowIndex].Cells[販売履歴Cell.byt変更].Value = true;
                //    dgv販売履歴.Rows[e.RowIndex].Cells[販売履歴Cell.byt削除].Value = false;
                //}
                //else
                //{
                //    // 「新規」列をチェック状態にする
                //    dgv販売履歴.Rows[e.RowIndex].Cells[販売履歴Cell.byt新規].Value = true;
                //    dgv販売履歴.Rows[e.RowIndex].Cells[販売履歴Cell.byt変更].Value = false;
                //    dgv販売履歴.Rows[e.RowIndex].Cells[販売履歴Cell.byt削除].Value = false;
                //}

                C11ValidateOnForm.新規変更削除列のチェック状態変更(e, 販売履歴Cell.byt販売履歴No,
                    販売履歴Cell.byt新規, 販売履歴Cell.byt変更, 販売履歴Cell.byt削除, ref dgv販売履歴);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "dgv販売履歴_CellValueChanged", ex);
            }
        }

        private void dgv販売履歴_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            try
            {
                //列が変わった場合は書式チェックを実施
                string value = e.FormattedValue.ToString();

                switch (e.ColumnIndex)
                {
                    case 販売履歴Cell.byt販売日時:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell日時型(dgv販売履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgv販売履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 販売履歴Cell.byt商品ID:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell半角入力(dgv販売履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgv販売履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 販売履歴Cell.byt顧客ID:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell禁止文字(dgv販売履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            if (!C11ValidateOnForm.IsValidateCell半角入力(dgv販売履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgv販売履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 販売履歴Cell.byt商品名:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgv販売履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgv販売履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 販売履歴Cell.byt商品単価:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell通貨型(dgv販売履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

							if (IsValidate販売金額(dgv販売履歴, e.RowIndex) == false)
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgv販売履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 販売履歴Cell.byt販売個数:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell符号無し数値型(dgv販売履歴, e.RowIndex, e.ColumnIndex, value))
                                //if (!C11ValidateOnForm.IsValidateCell通貨型(dgv販売履歴, e.RowIndex, e.ColumnIndex, value))
                                break;

							if (IsValidate販売金額(dgv販売履歴, e.RowIndex) == false)
                                break;

                            //必須入力で入力完了したものについてはメッセージを消去
                            dgv販売履歴.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }
                        break;

                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "dgv販売履歴_CellValidating", ex);
            }
        }

        
        private void dgv販売履歴_RowValidating(object sender, DataGridViewCellCancelEventArgs e)
        {
            try
            {
                //行が変わった場合は必須入力チェックを実施
                if (e.RowIndex <= dgv販売履歴.RowCount)
                {
					IsValidateDGV販売履歴(dgv販売履歴, e.RowIndex);
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "dgv販売履歴_RowValidating", ex);
            }
        }

        private void dgv販売履歴_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            try
            {
                e.Cancel = true;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "dgv販売履歴_DataError", ex);
            }
        }


        //private void btn選択行の新規を全てチェック_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        Cursor.Current = Cursors.WaitCursor;

        //        foreach (DataGridViewRow row in dgv販売履歴.SelectedRows)
        //        {
        //            if (IsValidate未入力行(row))
        //                continue;

        //            row.Cells[販売履歴Cell.byt新規].Value = true;
        //            row.Cells[販売履歴Cell.byt変更].Value = false;
        //            row.Cells[販売履歴Cell.byt削除].Value = false;
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        C04システム共通.ErrorLog("_201販売履歴", "btn選択行の新規を全てチェック_Click", ex);
        //    }
        //    finally
        //    {
        //        Cursor.Current = Cursors.Arrow;
        //    }
        //}

        //private void btn選択行の変更を全てチェック_Click(object sender, EventArgs e)
        //{
        //    try
        //    {
        //        Cursor.Current = Cursors.WaitCursor;

        //        foreach (DataGridViewRow row in dgv販売履歴.SelectedRows)
        //        {
        //            if (IsValidate未入力行(row))
        //                continue;

        //            row.Cells[販売履歴Cell.byt新規].Value = false;
        //            row.Cells[販売履歴Cell.byt変更].Value = true;
        //            row.Cells[販売履歴Cell.byt削除].Value = false;
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        C04システム共通.ErrorLog("_201販売履歴", "btn選択行の変更を全てチェック_Click", ex);
        //    }
        //    finally
        //    {
        //        Cursor.Current = Cursors.Arrow;
        //    }
        //}


        private void btn選択行の削除を全てチェック_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv販売履歴.SelectedRows)
                {
                    if (IsValidate未入力行(row))
                        continue;

                    row.Cells[販売履歴Cell.byt新規].Value = false;
                    row.Cells[販売履歴Cell.byt変更].Value = false;
                    row.Cells[販売履歴Cell.byt削除].Value = true;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "btn選択行の削除を全てチェック_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv販売履歴.SelectedRows)
                {
                    row.Cells[販売履歴Cell.byt新規].Value = false;
                    row.Cells[販売履歴Cell.byt変更].Value = false;
                    row.Cells[販売履歴Cell.byt削除].Value = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "btn選択行のチェックを全て外す_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnCSVファイル読込_Click(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {
                OpenFileDialog dlg = new OpenFileDialog();
                dlg.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";
                if (dlg.ShowDialog(this) == DialogResult.Cancel)
                    return;

                Cursor.Current = Cursors.WaitCursor;

                d03販売履歴bs.DataSource = null; 
                
                取込処理内部クラス 取込処理 = new 取込処理内部クラス();
                D03販売履歴.D03販売履歴DataTable dt = new D03販売履歴.D03販売履歴DataTable();

                if (!取込処理.CSV変換(dlg.FileName, dt, 2))
                {
					//string errmsg = 取込処理.LastErrorMessage 
					//    + "\n\n【" + Properties.Resources.MSG_I_詳細 + "】\n" + 取込処理.ErrorDetail;
					string errmsg = 取込処理.LastErrorMessage;
                    MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                if (dt.Count > C_最大値.CSV取込件数)
                {
                    string errmsg = string.Format(Properties.Resources.MSG_W_最大取込件数A件を超えています, (long)C_最大値.CSV取込件数);
                    MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                d03販売履歴._D03販売履歴.Merge(dt);

            }
            catch (Exception ex)
            {
                b正常終了 = false;
                C04システム共通.ErrorLog("_201販売履歴", "btnCSVファイル読込_Click", ex);
            }
            finally
            {
                d03販売履歴bs.DataSource = d03販売履歴._D03販売履歴;

                Cursor.Current = Cursors.Arrow;
            }

            if (b正常終了 == true)
                MessageBox.Show(Properties.Resources.MSG_I_読込が完了しました, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
            else
                MessageBox.Show(Properties.Resources.MSG_W_ファイルの読込に失敗しました, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
        }

        private void btn検索結果をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_検索結果をクリアしますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                d03販売履歴._D03販売履歴.Clear();

				lbl件数.Text = "";
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "btn検索結果をクリア_Click", ex);
            }
        }

        private void btnCSVファイル出力_Click(object sender, EventArgs e)
        {
            try
            {
                if (dgv販売履歴.SelectedRows.Count == 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_073, this.Text
						, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

                Cursor.Current = Cursors.WaitCursor;

				C06CSV.CreateCSVファイル(dgv販売履歴, sfd.FileName, true, 4, true, "");

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました, this.Text
					, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "btnCSVファイル出力_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }


        private void btn確定_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;
                if (false == IsValidate())
                {
                    return;
                }

                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_入力した内容を登録しますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                Cursor.Current = Cursors.WaitCursor;

                Insert販売履歴();
                Update販売履歴();
                Delete販売履歴();

                //C02業務共通処理.M02商品を更新();
				C02業務共通処理.M02商品を更新();

                //C02業務共通処理.未登録顧客の顧客Noを0にする();
				C02業務共通処理.未登録顧客の顧客Noを0にする();

                d03販売履歴._D03販売履歴.Clear();

                MessageBox.Show(Properties.Resources.MSG_I_登録が完了しました, this.Text, MessageBoxButtons.OK, 
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "btn確定_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_201販売履歴", "btnキャンセル_Click", ex);
            }

        }




        #endregion






    }



}
